# SPDX-FileCopyrightText: 2024 Justin Myers
#
# SPDX-License-Identifier: MIT
"""
Board stub for MakerDiary nRF52840 MDK USB Dongle
 - port: nordic
 - board_id: makerdiary_nrf52840_mdk_usb_dongle
 - NVM size: 8192
 - Included modules: _asyncio, _bleio, _pixelmap, adafruit_bus_device, adafruit_pixelbuf, aesio, alarm, analogio, array, atexit, audiobusio, audiocore, audiomixer, audiomp3, audiopwmio, binascii, bitbangio, bitmapfilter, bitmaptools, board, builtins, builtins.pow3, busdisplay, busio, busio.SPI, busio.UART, codeop, collections, countio, digitalio, displayio, epaperdisplay, errno, fontio, fourwire, framebufferio, getpass, gifio, i2cdisplaybus, io, jpegio, json, keypad, keypad.KeyMatrix, keypad.Keys, keypad.ShiftRegisterKeys, keypad_demux, keypad_demux.DemuxKeyMatrix, locale, lvfontio, math, memorymap, microcontroller, msgpack, neopixel_write, nvm, onewireio, os, os.getenv, paralleldisplaybus, pulseio, pwmio, rainbowio, random, re, rgbmatrix, rotaryio, rtc, sdcardio, select, sharpdisplay, storage, struct, supervisor, synthio, sys, terminalio, tilepalettemapper, time, touchio, traceback, ulab, usb_cdc, usb_hid, usb_midi, vectorio, warnings, watchdog, zlib
 - Frozen libraries: 
"""

# Imports
import microcontroller


# Board Info:
board_id: str


# Pins:
AIN0: microcontroller.Pin  # P0_02
AIN1: microcontroller.Pin  # P0_03
AIN2: microcontroller.Pin  # P0_04
AIN3: microcontroller.Pin  # P0_05
AREF: microcontroller.Pin  # P0_04
VDIV: microcontroller.Pin  # P0_05
NFC1: microcontroller.Pin  # P0_09
NFC2: microcontroller.Pin  # P0_10
P2: microcontroller.Pin  # P0_02
P3: microcontroller.Pin  # P0_03
P4: microcontroller.Pin  # P0_04
P5: microcontroller.Pin  # P0_05
P6: microcontroller.Pin  # P0_06
P7: microcontroller.Pin  # P0_07
P8: microcontroller.Pin  # P0_08
P9: microcontroller.Pin  # P0_09
P10: microcontroller.Pin  # P0_10
P18: microcontroller.Pin  # P0_18
P19: microcontroller.Pin  # P0_19
P20: microcontroller.Pin  # P0_20
P21: microcontroller.Pin  # P0_21
P22: microcontroller.Pin  # P0_22
P23: microcontroller.Pin  # P0_23
P24: microcontroller.Pin  # P0_24
LED_RED: microcontroller.Pin  # P0_23
LED_GREEN: microcontroller.Pin  # P0_22
LED_BLUE: microcontroller.Pin  # P0_24
BUTTON: microcontroller.Pin  # P0_18


# Members:

# Unmapped:
#   none
