/*
 * This file is part of the MicroPython project, http://micropython.org/
 *
 * The MIT License (MIT)
 *
 * SPDX-FileCopyrightText: Copyright (c) 2013, 2014 Damien P. George
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// *FORMAT-OFF*

#ifdef __clang__
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Winitializer-overrides"
#endif // __clang__
#if __GNUC__ >= 5
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Woverride-init"
#endif // __GNUC__ >= 5

#include "supervisor/linker.h"

#if MICROPY_OPT_COMPUTED_GOTO_SAVE_SPACE
#define COMPUTE_ENTRY(x) ((char *)(x) - (char *) && entry_MP_BC_LOAD_CONST_FALSE)
typedef int16_t entry_table_type;
#else
#define COMPUTE_ENTRY(x) (x)
typedef void *entry_table_type;
#endif

static entry_table_type const PLACE_IN_DTCM_DATA(entry_table[256]) = {
    [0 ... 255] = COMPUTE_ENTRY(&& entry_default),
    [MP_BC_LOAD_CONST_FALSE] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_FALSE),
    [MP_BC_LOAD_CONST_NONE] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_NONE),
    [MP_BC_LOAD_CONST_TRUE] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_TRUE),
    [MP_BC_LOAD_CONST_SMALL_INT] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_SMALL_INT),
    [MP_BC_LOAD_CONST_STRING] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_STRING),
    [MP_BC_LOAD_CONST_OBJ] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_OBJ),
    [MP_BC_LOAD_NULL] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_NULL),
    [MP_BC_LOAD_FAST_N] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_FAST_N),
    [MP_BC_LOAD_DEREF] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_DEREF),
    [MP_BC_LOAD_NAME] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_NAME),
    [MP_BC_LOAD_GLOBAL] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_GLOBAL),
    [MP_BC_LOAD_ATTR] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_ATTR),
    [MP_BC_LOAD_METHOD] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_METHOD),
    [MP_BC_LOAD_SUPER_METHOD] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_SUPER_METHOD),
    [MP_BC_LOAD_BUILD_CLASS] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_BUILD_CLASS),
    [MP_BC_LOAD_SUBSCR] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_SUBSCR),
    [MP_BC_STORE_FAST_N] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_FAST_N),
    [MP_BC_STORE_DEREF] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_DEREF),
    [MP_BC_STORE_NAME] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_NAME),
    [MP_BC_STORE_GLOBAL] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_GLOBAL),
    [MP_BC_STORE_ATTR] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_ATTR),
    [MP_BC_STORE_SUBSCR] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_SUBSCR),
    [MP_BC_DELETE_FAST] = COMPUTE_ENTRY(&& entry_MP_BC_DELETE_FAST),
    [MP_BC_DELETE_DEREF] = COMPUTE_ENTRY(&& entry_MP_BC_DELETE_DEREF),
    [MP_BC_DELETE_NAME] = COMPUTE_ENTRY(&& entry_MP_BC_DELETE_NAME),
    [MP_BC_DELETE_GLOBAL] = COMPUTE_ENTRY(&& entry_MP_BC_DELETE_GLOBAL),
    [MP_BC_DUP_TOP] = COMPUTE_ENTRY(&& entry_MP_BC_DUP_TOP),
    [MP_BC_DUP_TOP_TWO] = COMPUTE_ENTRY(&& entry_MP_BC_DUP_TOP_TWO),
    [MP_BC_POP_TOP] = COMPUTE_ENTRY(&& entry_MP_BC_POP_TOP),
    [MP_BC_ROT_TWO] = COMPUTE_ENTRY(&& entry_MP_BC_ROT_TWO),
    [MP_BC_ROT_THREE] = COMPUTE_ENTRY(&& entry_MP_BC_ROT_THREE),
    [MP_BC_JUMP] = COMPUTE_ENTRY(&& entry_MP_BC_JUMP),
    [MP_BC_POP_JUMP_IF_TRUE] = COMPUTE_ENTRY(&& entry_MP_BC_POP_JUMP_IF_TRUE),
    [MP_BC_POP_JUMP_IF_FALSE] = COMPUTE_ENTRY(&& entry_MP_BC_POP_JUMP_IF_FALSE),
    [MP_BC_JUMP_IF_TRUE_OR_POP] = COMPUTE_ENTRY(&& entry_MP_BC_JUMP_IF_TRUE_OR_POP),
    [MP_BC_JUMP_IF_FALSE_OR_POP] = COMPUTE_ENTRY(&& entry_MP_BC_JUMP_IF_FALSE_OR_POP),
    [MP_BC_SETUP_WITH] = COMPUTE_ENTRY(&& entry_MP_BC_SETUP_WITH),
    [MP_BC_WITH_CLEANUP] = COMPUTE_ENTRY(&& entry_MP_BC_WITH_CLEANUP),
    [MP_BC_UNWIND_JUMP] = COMPUTE_ENTRY(&& entry_MP_BC_UNWIND_JUMP),
    [MP_BC_SETUP_EXCEPT] = COMPUTE_ENTRY(&& entry_MP_BC_SETUP_EXCEPT),
    [MP_BC_SETUP_FINALLY] = COMPUTE_ENTRY(&& entry_MP_BC_SETUP_FINALLY),
    [MP_BC_END_FINALLY] = COMPUTE_ENTRY(&& entry_MP_BC_END_FINALLY),
    [MP_BC_GET_ITER] = COMPUTE_ENTRY(&& entry_MP_BC_GET_ITER),
    [MP_BC_GET_ITER_STACK] = COMPUTE_ENTRY(&& entry_MP_BC_GET_ITER_STACK),
    [MP_BC_FOR_ITER] = COMPUTE_ENTRY(&& entry_MP_BC_FOR_ITER),
    [MP_BC_POP_EXCEPT_JUMP] = COMPUTE_ENTRY(&& entry_MP_BC_POP_EXCEPT_JUMP),
    [MP_BC_BUILD_TUPLE] = COMPUTE_ENTRY(&& entry_MP_BC_BUILD_TUPLE),
    [MP_BC_BUILD_LIST] = COMPUTE_ENTRY(&& entry_MP_BC_BUILD_LIST),
    [MP_BC_BUILD_MAP] = COMPUTE_ENTRY(&& entry_MP_BC_BUILD_MAP),
    [MP_BC_STORE_MAP] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_MAP),
    #if MICROPY_PY_BUILTINS_SET
    [MP_BC_BUILD_SET] = COMPUTE_ENTRY(&& entry_MP_BC_BUILD_SET),
    #endif
    #if MICROPY_PY_BUILTINS_SLICE
    [MP_BC_BUILD_SLICE] = COMPUTE_ENTRY(&& entry_MP_BC_BUILD_SLICE),
    #endif
    [MP_BC_STORE_COMP] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_COMP),
    [MP_BC_UNPACK_SEQUENCE] = COMPUTE_ENTRY(&& entry_MP_BC_UNPACK_SEQUENCE),
    [MP_BC_UNPACK_EX] = COMPUTE_ENTRY(&& entry_MP_BC_UNPACK_EX),
    [MP_BC_MAKE_FUNCTION] = COMPUTE_ENTRY(&& entry_MP_BC_MAKE_FUNCTION),
    [MP_BC_MAKE_FUNCTION_DEFARGS] = COMPUTE_ENTRY(&& entry_MP_BC_MAKE_FUNCTION_DEFARGS),
    [MP_BC_MAKE_CLOSURE] = COMPUTE_ENTRY(&& entry_MP_BC_MAKE_CLOSURE),
    [MP_BC_MAKE_CLOSURE_DEFARGS] = COMPUTE_ENTRY(&& entry_MP_BC_MAKE_CLOSURE_DEFARGS),
    [MP_BC_CALL_FUNCTION] = COMPUTE_ENTRY(&& entry_MP_BC_CALL_FUNCTION),
    [MP_BC_CALL_FUNCTION_VAR_KW] = COMPUTE_ENTRY(&& entry_MP_BC_CALL_FUNCTION_VAR_KW),
    [MP_BC_CALL_METHOD] = COMPUTE_ENTRY(&& entry_MP_BC_CALL_METHOD),
    [MP_BC_CALL_METHOD_VAR_KW] = COMPUTE_ENTRY(&& entry_MP_BC_CALL_METHOD_VAR_KW),
    [MP_BC_RETURN_VALUE] = COMPUTE_ENTRY(&& entry_MP_BC_RETURN_VALUE),
    [MP_BC_RAISE_LAST] = COMPUTE_ENTRY(&& entry_MP_BC_RAISE_LAST),
    [MP_BC_RAISE_OBJ] = COMPUTE_ENTRY(&& entry_MP_BC_RAISE_OBJ),
    [MP_BC_RAISE_FROM] = COMPUTE_ENTRY(&& entry_MP_BC_RAISE_FROM),
    [MP_BC_YIELD_VALUE] = COMPUTE_ENTRY(&& entry_MP_BC_YIELD_VALUE),
    [MP_BC_YIELD_FROM] = COMPUTE_ENTRY(&& entry_MP_BC_YIELD_FROM),
    [MP_BC_IMPORT_NAME] = COMPUTE_ENTRY(&& entry_MP_BC_IMPORT_NAME),
    [MP_BC_IMPORT_FROM] = COMPUTE_ENTRY(&& entry_MP_BC_IMPORT_FROM),
    [MP_BC_IMPORT_STAR] = COMPUTE_ENTRY(&& entry_MP_BC_IMPORT_STAR),
    [MP_BC_LOAD_CONST_SMALL_INT_MULTI ... MP_BC_LOAD_CONST_SMALL_INT_MULTI + MP_BC_LOAD_CONST_SMALL_INT_MULTI_NUM - 1] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_CONST_SMALL_INT_MULTI),
    [MP_BC_LOAD_FAST_MULTI ... MP_BC_LOAD_FAST_MULTI + MP_BC_LOAD_FAST_MULTI_NUM - 1] = COMPUTE_ENTRY(&& entry_MP_BC_LOAD_FAST_MULTI),
    [MP_BC_STORE_FAST_MULTI ... MP_BC_STORE_FAST_MULTI + MP_BC_LOAD_FAST_MULTI_NUM - 1] = COMPUTE_ENTRY(&& entry_MP_BC_STORE_FAST_MULTI),
    [MP_BC_UNARY_OP_MULTI ... MP_BC_UNARY_OP_MULTI + MP_BC_UNARY_OP_MULTI_NUM - 1] = COMPUTE_ENTRY(&& entry_MP_BC_UNARY_OP_MULTI),
    [MP_BC_BINARY_OP_MULTI ... MP_BC_BINARY_OP_MULTI + MP_BC_BINARY_OP_MULTI_NUM - 1] = COMPUTE_ENTRY(&& entry_MP_BC_BINARY_OP_MULTI),
};

#ifdef __clang__
#pragma clang diagnostic pop
#endif // __clang__
#if __GNUC__ >= 5
#pragma GCC diagnostic pop
#endif // __GNUC__ >= 5
