# Setup

The TinkeringTech ScoutMakes Azul is a bluetooth enabled, feather format, open source platform featuring the nRF52840 from Nordic Semiconductors. The design is based on the Adafruit nRF52840 feather express and uses the Raytac MDBT50Q-1MV2 module.

Schematic, datasheet, pin mapping etc. can be found over [here](https://tinkeringtech.com/scoutmakes-azul).

features:
- ARM Cortex M4F (with HW floating point acceleration) running at 64MHz
- Raytac MDBT50Q-1MV2  BLE module. FCC / IC / TELEC certified module
- 1MB flash and 256KB SRAM
- Native Open Source USB stack – pre-programmed with UF2 bootloader and CircuitPython
- 128×32 OLED display
- USB type-C
- On/off power switch
- Bluetooth Low Energy compatible 2.4GHz radio (Details available in the nRF52840 product specification)
- BT5.1 & BT5 Bluetooth Specification Certified
- Supports BT5 Long Range Feature
- 1.7v to 3.3v operation with internal linear and DC/DC voltage regulators
- 21 GPIO, 6 x 12-bit ADC pins, up to 12 PWM outputs (3 PWM modules with 4 outputs each)
- Pin #3 red LED for general purpose blinking,
- Programmable NeoPixel for colorful feedback
- 4 mounting holes
- Reset button
- Works out of the box with Adafruit feather wings.
- Open source design.
