"""Metadata introspection for the SQLite Graph plugin used by cjm-ctl to generate the registration manifest."""

# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/meta.ipynb.

# %% auto 0
__all__ = ['get_plugin_metadata']

# %% ../nbs/meta.ipynb 3
import os
import sys
from typing import Any, Dict

# %% ../nbs/meta.ipynb 4
def get_plugin_metadata() -> Dict[str, Any]:  # Plugin metadata for manifest generation
    """Return metadata required to register this plugin with the PluginManager."""
    # Fallback base path (current behavior for backward compatibility)
    base_path = os.path.dirname(os.path.dirname(sys.executable))
    
    # Use CJM config if available, else fallback to env-relative paths
    cjm_data_dir = os.environ.get("CJM_DATA_DIR")
    
    # Plugin data directory
    plugin_name = "cjm-graph-plugin-sqlite"
    if cjm_data_dir:
        data_dir = os.path.join(cjm_data_dir, plugin_name)
    else:
        data_dir = os.path.join(base_path, "data")
    
    db_path = os.path.join(data_dir, "context_graph.db")
    
    # Ensure data directory exists
    os.makedirs(data_dir, exist_ok=True)

    return {
        "name": plugin_name,
        "version": "0.1.0",
        "type": "graph",
        "category": "knowledge-management",
        "interface": "cjm_graph_plugin_system.plugin_interface.GraphPlugin",

        "module": "cjm_graph_plugin_sqlite.plugin",
        "class": "SQLiteGraphPlugin",

        # Critical: The absolute path to THIS environment's python
        "python_path": sys.executable,

        "db_path": db_path,

        "resources": {
            "requires_gpu": False,
            "min_system_ram_mb": 512
        },

        "env_vars": {}
    }
