"""Pydantic models for deferred object deletion."""

from datetime import datetime
from uuid import UUID

from pydantic import BaseModel, ConfigDict


class DeferredObjectDeletionBase(BaseModel):
    """Base model for deferred object deletion.

    Attributes:
        uri: URI for AWS S3 object, Azure Storage Blob, etc.
    """

    uri: str


class DeferredObjectDeletionCreate(DeferredObjectDeletionBase):
    """Model for creating a deferred object deletion entry."""


class DeferredObjectDeletion(DeferredObjectDeletionBase):
    """Model for deferred object deletion data with database fields.

    Attributes:
        deferred_object_deletion_id: Unique identifier for the deferred object deletion.
        updated_by: User who initiated the deletion.
        created_date: Date and time when the deletion request was initiated.
    """

    deferred_object_deletion_id: UUID
    updated_by: str
    created_date: datetime

    model_config = ConfigDict(from_attributes=True)
