# -*- coding: utf-8 -*-
"""
Created on Sun Nov 29 19:05:53 2015

@author: Ben
"""
import matplotlib as _mpl
import os as _os
import numpy as _np

#Create lists of colors to cycle through when creating plots with multiple 
#curves, markers, etc.
c_lists = {}
c_lists['std'] = [[1,0,0], [0,0,1], [0,.6,0], [1,.5,0], [.7,0,.5], [0,.5,.5], \
    [.4,0,.7], [0.45,0.33,0.22], [0,0,0]]
#Uniformly scale down all the colors to create sets of darker colors
c_lists['dark'] = [[0.5,0,0,1], [0,0,0.5,1], [0,.3,0,1], [0.5,.25,0,1], \
    [.35,0,.25,1], [0,.25,.25,1], [.2,0,.35,1], [0.225,0.165,0.11,1], \
    [0,0,0,1]]
c_lists['darker'] = [[0.35,0,0], [0,0,0.35], [0,.21,0], [0.35,.175,0], \
    [.245,0,.175], [0,.175,.175], [.14,0,.245], [0.1575,0.1155,0.077], \
    [0,0,0]]
#Create pastel version of the color list
#These were generated by setting the alpha channel to 0.7, and then using the
#following pseudocode to convert to plain RGB values with a white background
#Source => Target = (BGColor + Source) =
#Target.R = ((1 - Source.A) * BGColor.R) + (Source.A * Source.R)
#Target.G = ((1 - Source.A) * BGColor.G) + (Source.A * Source.G)
#Target.B = ((1 - Source.A) * BGColor.B) + (Source.A * Source.B)
c_lists['pastel'] = [[1,0.3,0.3], [0.3,0.3,1], [0.3,0.72,0.3], [1,0.65,0.3], \
    [0.79,0.3,0.65], [0.3,0.65,0.65], [0.58,0.3,0.79], [0.615,0.531,0.454], \
    [0.3,0.3,0.3]]

#Load custom colormaps
#(These colormaps were originally stored in a pickle file and loaded upon
#importing clearplot.  This caused issues with github and PyPI (see Issue #1 
#on github).  Instead we load the colormap definitions from csv files.)
#Read the color map directory to the list of color map names
def _load_c_maps():
    c_map_dir = _os.path.join(_os.path.dirname(__file__), 'color_maps')
    c_map_datafile_names = _os.listdir(c_map_dir)
    c_maps = {}
    for c_map_datafile_name in c_map_datafile_names:
        c_map_name = c_map_datafile_name[:-4]
        c_map_data_path = _os.path.join(c_map_dir, c_map_datafile_name)
        c_map_data = _np.loadtxt(c_map_data_path, delimiter = ',')
        c_maps[c_map_name] = _mpl.colors.ListedColormap(c_map_data)
    return(c_maps)

c_maps = _load_c_maps()