# coding: utf-8

"""
    Clever API

    The Clever API

    OpenAPI spec version: 1.2.0

    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import os
import sys
import unittest
import urllib3

import clever
from clever.rest import ApiException
from clever.apis.data_api import DataApi

class MockPoolManager(object):
    def __init__(self, tc):
        self._tc = tc
        self._reqs = []

    def expect_request(self, *args, **kwargs):
        self._reqs.append((args, kwargs))

    def request(self, *args, **kwargs):
        return urllib3.HTTPResponse(status=200, body='{"data": {"name": "Oh haiô"}}')

class TestDataApi(unittest.TestCase):
    """ DataApi unit test stubs """

    def setUp(self):
        self.api = clever.apis.data_api.DataApi()
        self.api.api_client.configuration.access_token = 'TEST_TOKEN'

    def tearDown(self):
        pass

    def test_unicode_send(self):
        # Make sure unicode requests can be sent. 404 error is an ApiException
        self.assertRaises(ApiException, self.api.get_district, u'☃')

    def test_unicode_receive(self):
        mock_pool = MockPoolManager(self)
        real_pool = self.api.api_client.rest_client.pool_manager
        self.api.api_client.rest_client.pool_manager = mock_pool

        mock_pool.expect_request('GET', 'https://api.clever.com/v2.0/districts/something')
        # Make sure unicode responses can be received.
        self.assertEqual(u'Oh haiô', self.api.get_district('something').data.name)
        self.api.api_client.rest_client.pool_manager = real_pool


    def test_get_contact(self):
        """
        Test case for get_contact


        """
        pass

    def test_get_contacts(self):
        """
        Test case for get_contacts


        """
        pass

    def test_get_contacts_for_student(self):
        """
        Test case for get_contacts_for_student


        """
        pass

    def test_get_district(self):
        """
        Test case for get_district


        """
        pass

    def test_get_district_admin(self):
        """
        Test case for get_district_admin


        """
        pass

    def test_get_district_admins(self):
        """
        Test case for get_district_admins


        """
        pass

    def test_get_district_for_school(self):
        """
        Test case for get_district_for_school


        """
        pass

    def test_get_district_for_section(self):
        """
        Test case for get_district_for_section


        """
        pass

    def test_get_district_for_student(self):
        """
        Test case for get_district_for_student


        """
        pass

    def test_get_district_for_student_contact(self):
        """
        Test case for get_district_for_student_contact


        """
        pass

    def test_get_district_for_teacher(self):
        """
        Test case for get_district_for_teacher


        """
        pass

    def test_get_district_status(self):
        """
        Test case for get_district_status


        """
        pass

    def test_get_districts(self):
        """
        Test case for get_districts


        """
        pass

    def test_get_grade_levels_for_teacher(self):
        """
        Test case for get_grade_levels_for_teacher


        """
        pass

    def test_get_school(self):
        """
        Test case for get_school


        """
        pass

    def test_get_school_admin(self):
        """
        Test case for get_school_admin


        """
        pass

    def test_get_school_admins(self):
        """
        Test case for get_school_admins


        """
        pass

    def test_get_school_for_section(self):
        """
        Test case for get_school_for_section


        """
        pass

    def test_get_school_for_student(self):
        """
        Test case for get_school_for_student


        """
        pass

    def test_get_school_for_teacher(self):
        """
        Test case for get_school_for_teacher


        """
        pass

    def test_get_schools(self):
        """
        Test case for get_schools


        """
        pass

    def test_get_schools_for_school_admin(self):
        """
        Test case for get_schools_for_school_admin


        """
        pass

    def test_get_section(self):
        """
        Test case for get_section


        """
        pass

    def test_get_sections(self):
        """
        Test case for get_sections


        """
        pass

    def test_get_sections_for_school(self):
        """
        Test case for get_sections_for_school


        """
        pass

    def test_get_sections_for_student(self):
        """
        Test case for get_sections_for_student


        """
        pass

    def test_get_sections_for_teacher(self):
        """
        Test case for get_sections_for_teacher


        """
        pass

    def test_get_student(self):
        """
        Test case for get_student


        """
        pass

    def test_get_student_for_contact(self):
        """
        Test case for get_student_for_contact


        """
        pass

    def test_get_students(self):
        """
        Test case for get_students


        """
        pass

    def test_get_students_for_school(self):
        """
        Test case for get_students_for_school


        """
        pass

    def test_get_students_for_section(self):
        """
        Test case for get_students_for_section


        """
        pass

    def test_get_students_for_teacher(self):
        """
        Test case for get_students_for_teacher


        """
        pass

    def test_get_teacher(self):
        """
        Test case for get_teacher


        """
        pass

    def test_get_teacher_for_section(self):
        """
        Test case for get_teacher_for_section


        """
        pass

    def test_get_teachers(self):
        """
        Test case for get_teachers


        """
        pass

    def test_get_teachers_for_school(self):
        """
        Test case for get_teachers_for_school


        """
        pass

    def test_get_teachers_for_section(self):
        """
        Test case for get_teachers_for_section


        """
        pass

    def test_get_teachers_for_student(self):
        """
        Test case for get_teachers_for_student


        """
        pass


if __name__ == '__main__':
    unittest.main()
