# 变更日志

## [v0.3.3] - 2025-06-09

### 🔧 项目信息更新
- **GitHub仓库更新**：更新项目仓库地址为 https://github.com/ozil111/cli-test-framework
- **PyPI主页优化**：恢复使用README.md作为PyPI项目主页描述，更适合对外展示
- **文档链接调整**：用户手册通过Documentation链接访问，结构更加清晰

### 📚 链接修复
- 更新所有文档中的GitHub仓库链接
- 修正PyPI项目的Documentation链接指向
- 改善文档访问体验和项目结构

## [v0.3.2] - 2024-06-09

### 🔧 重大改进
- **PyPI文档更新**：PyPI项目页面现在显示完整的用户手册内容（包含Setup模块文档）
- **README重构**：更新README.md添加Setup模块使用示例和配置说明
- **文档源切换**：setup.py现在使用`docs/user_manual.md`作为PyPI项目描述

### 📚 文档增强
- 在README中添加了Setup模块的快速使用示例
- 添加了带环境变量配置的JSON/YAML示例
- 增加了指向完整用户手册的链接和说明
- 改善了文档结构和可读性

## [v0.3.1] - 2024-06-08

### 🔧 改进
- **文档更新**：完善了用户手册中的Setup模块文档
- **示例增强**：增加了更多详细的配置示例和最佳实践说明
- **PyPI发布**：确保最新的用户手册包含在PyPI包中

### 📚 文档修复
- 修复了用户手册格式问题
- 改进了Setup模块的使用示例
- 补充了更多自定义插件开发指南

## [v0.3.0] - 2025-06-07

### 🎉 重大新功能 - Setup模块系统

#### 插件化Setup架构
- **BaseSetup抽象基类**：定义了setup插件的标准接口，支持setup()和teardown()方法
- **SetupManager管理器**：统一管理多个setup插件的生命周期
- **可扩展设计**：用户可以轻松创建自定义setup插件

#### 内置环境变量插件
- **EnvironmentSetup插件**：自动设置和管理环境变量
- **智能恢复机制**：测试完成后自动恢复原始环境状态，支持新增和覆盖的环境变量
- **配置文件集成**：直接在JSON/YAML测试配置中定义环境变量

#### 全面Runner集成
- **JSONRunner**：完全支持setup配置的加载和执行
- **YAMLRunner**：完全支持setup配置的加载和执行  
- **ParallelJSONRunner**：完全支持setup配置，在并行模式下正确处理setup/teardown
- **自动生命周期**：setup和teardown在测试前后自动执行

#### 配置文件语法扩展
```json
{
  "setup": {
    "environment_variables": {
      "TEST_ENV": "development",
      "API_URL": "http://localhost:8080"
    }
  },
  "test_cases": [...]
}
```

### 🔧 改进和修复
- **Python版本要求**：从Python 3.6+更新为Python 3.9+（由于依赖版本要求）
- **错误处理增强**：改进了setup/teardown的异常处理，使用try-finally确保清理总是执行
- **并行安全**：Setup模块在并行执行模式下的线程安全处理
- **包导出修复**：移除了错误的FileComparator导出

### 🧪 测试覆盖
- **新增16个单元测试**：覆盖setup模块所有核心功能
- **集成测试**：确保与所有runner的兼容性
- **边界条件测试**：测试空配置、错误情况等边界条件

### 📚 文档更新
- **用户手册扩展**：新增完整的Setup模块章节，包含详细使用说明和最佳实践
- **示例代码**：提供了完整的使用示例和自定义插件示例
- **API文档**：完整的setup模块API文档和类型注解

### ⚠️ 破坏性变更
- **Python版本要求**：从3.6+更新为3.9+
- **包结构调整**：setup模块相关类现在从cli_test_framework包导出

### 🚀 迁移指南
- **现有代码兼容**：现有的测试配置文件无需修改即可正常工作
- **新功能使用**：在配置文件中添加setup部分即可使用环境变量设置
- **自定义插件**：继承BaseSetup类创建自定义setup插件

---

## [v2.0.0] - 2025-05-27

### 🚀 重大新功能

#### 并行测试执行
- **多线程并行执行**：支持 I/O 密集型测试的高效并行处理
- **多进程并行执行**：支持 CPU 密集型测试的完全隔离执行
- **可配置并发数**：灵活设置最大工作线程/进程数
- **性能提升**：典型场景下可获得 2-4 倍加速比

#### 智能命令解析
- **复杂命令支持**：智能处理 `"python ./script.py"` 等复杂命令格式
- **系统命令识别**：自动识别系统命令和相对路径可执行文件
- **路径解析增强**：更准确的路径转换和命令构建

### ✨ 功能增强

#### 线程安全设计
- **结果收集锁**：确保并发环境下测试结果的正确性
- **输出控制锁**：防止并发输出混乱
- **异常隔离**：单个测试失败不影响其他测试

#### 新增运行器
- **ParallelJSONRunner**：支持并行执行的 JSON 测试运行器
- **进程工作器**：独立的进程执行模块，解决序列化问题

### 🔧 问题修复

#### 命令解析修复
- **修复问题**：`'D:\Document\xcode\Compare-File-Tool\python' 不是内部或外部命令`
- **根本原因**：复杂命令字符串被整体当作命令名处理
- **解决方案**：智能分割命令字符串，分别处理命令和参数部分

#### 路径解析优化
- **系统命令白名单**：扩展系统命令识别列表
- **相对路径处理**：改进相对路径和绝对路径的判断逻辑

### 📚 文档更新

#### README 全面重写
- **英文版 README.md**：全新的结构和内容组织
- **中文版 README_cn.md**：同步更新，保持一致性
- **并行测试指南**：详细的 PARALLEL_TESTING_GUIDE.md

#### 新增示例
- **parallel_example.py**：性能比较演示
- **performance_test.py**：自动化性能测试
- **test_parallel_runner.py**：并行功能单元测试

### 🎯 性能基准

| 测试场景 | 顺序执行 | 并行执行(线程) | 并行执行(进程) | 加速比 |
|----------|----------|----------------|----------------|--------|
| 6个简单测试 | 0.12秒 | 0.03秒 | 0.16秒 | 3.84x |
| 10个I/O测试 | 5.2秒 | 1.4秒 | 2.1秒 | 3.7x |
| 20个CPU测试 | 12.8秒 | 8.9秒 | 6.2秒 | 2.1x |

### 🔄 向后兼容性

- **完全兼容**：现有的 JSONRunner 代码无需修改
- **渐进式升级**：可以逐步迁移到并行执行
- **配置兼容**：现有测试用例配置文件无需更改

### 📦 依赖更新

```txt
pytest
PyYAML  # 修正了之前的 pyyaml 拼写错误
concurrent.futures  # 标准库，无需额外安装
```

### 🚀 使用示例

#### 基本并行执行
```python
from src.runners.parallel_json_runner import ParallelJSONRunner

runner = ParallelJSONRunner(
    config_file="test_cases.json",
    max_workers=4,
    execution_mode="thread"
)
success = runner.run_tests()
```

#### 性能比较
```bash
# 运行性能比较示例
python parallel_example.py

# 输出示例：
# 顺序执行时间:     0.12 秒
# 并行执行时间(线程): 0.03 秒 (加速比: 3.84x)
# 并行执行时间(进程): 0.16 秒 (加速比: 0.73x)
```

### 🔮 未来计划

- **分布式执行**：支持跨机器的测试执行
- **Web UI**：提供图形化的测试管理界面
- **更多格式支持**：XML、TOML 等配置格式
- **性能监控**：详细的执行时间和资源使用统计

---

## [v1.0.0] - 2025-03-05

### 初始版本
- 基础的 JSON/YAML 测试运行器
- 路径解析功能
- 断言机制
- 报告生成 