"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import pydantic
from speakeasy.new_openapi.types import BaseModel
from typing_extensions import Annotated, TypedDict


class StringArrayFormat(str, Enum):
    r"""String enum with x-speakeasy-enums as array (full coverage)"""

    AWAITING_REVIEW_PROCESS = "pending_review"
    COMPLETELY_APPROVED_AND_FINALIZED = "approved_final"
    PERMANENTLY_REJECTED_FOREVER = "rejected_permanently"


class StringMapFormat(str, Enum):
    r"""String enum with x-speakeasy-enums as map (full coverage)"""

    MINIMAL_IMPORTANCE_LEVEL = "low_priority"
    MODERATE_IMPORTANCE_LEVEL = "medium_priority"
    SIGNIFICANT_IMPORTANCE_LEVEL = "high_priority"
    EXTREMELY_URGENT_AND_CRITICAL = "critical_urgent"


class StringPartialMapFormat(str, Enum):
    r"""String enum with x-speakeasy-enums as map (partial coverage)"""

    INITIAL_DRAFT_VERSION = "draft_mode"
    UNDER_REVIEW = "under_review"
    LIVE_PUBLISHED_CONTENT = "published_live"
    ARCHIVED_OLD = "archived_old"


class IntegerMapFormat(int, Enum):
    r"""Integer enum with x-speakeasy-enums as map (full coverage)"""

    CONTINUE_PROCESSING_REQUEST = 100
    SUCCESSFUL_OPERATION_COMPLETE = 200
    REDIRECT_TO_ANOTHER_LOCATION = 300
    CLIENT_SIDE_ERROR_OCCURRED = 400


class IntegerPartialMapFormat(int, Enum):
    r"""Integer enum with x-speakeasy-enums as map (partial coverage)"""

    PRIMARY_FIRST_OPTION = 1
    TWO = 2
    MIDDLE_THIRD_CHOICE = 3
    FOUR = 4
    FINAL_FIFTH_SELECTION = 5


class TestEnumFormatsRequestTypedDict(TypedDict):
    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    string_array_format: StringArrayFormat
    r"""String enum with x-speakeasy-enums as array (full coverage)"""
    string_map_format: StringMapFormat
    r"""String enum with x-speakeasy-enums as map (full coverage)"""
    string_partial_map_format: StringPartialMapFormat
    r"""String enum with x-speakeasy-enums as map (partial coverage)"""
    integer_map_format: IntegerMapFormat
    r"""Integer enum with x-speakeasy-enums as map (full coverage)"""
    integer_partial_map_format: IntegerPartialMapFormat
    r"""Integer enum with x-speakeasy-enums as map (partial coverage)"""


class TestEnumFormatsRequest(BaseModel):
    __test__ = False

    string_array_format: Annotated[
        StringArrayFormat, pydantic.Field(alias="stringArrayFormat")
    ]
    r"""String enum with x-speakeasy-enums as array (full coverage)"""

    string_map_format: Annotated[
        StringMapFormat, pydantic.Field(alias="stringMapFormat")
    ]
    r"""String enum with x-speakeasy-enums as map (full coverage)"""

    string_partial_map_format: Annotated[
        StringPartialMapFormat, pydantic.Field(alias="stringPartialMapFormat")
    ]
    r"""String enum with x-speakeasy-enums as map (partial coverage)"""

    integer_map_format: Annotated[
        IntegerMapFormat, pydantic.Field(alias="integerMapFormat")
    ]
    r"""Integer enum with x-speakeasy-enums as map (full coverage)"""

    integer_partial_map_format: Annotated[
        IntegerPartialMapFormat, pydantic.Field(alias="integerPartialMapFormat")
    ]
    r"""Integer enum with x-speakeasy-enums as map (partial coverage)"""


class TestEnumFormatsResponseTypedDict(TypedDict):
    r"""OK"""

    __test__ = False  # pyright: ignore[reportGeneralTypeIssues]

    message: str


class TestEnumFormatsResponse(BaseModel):
    r"""OK"""

    __test__ = False

    message: str
