"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
from speakeasy.new_openapi.models import SDKBaseError
from speakeasy.new_openapi.types import BaseModel
from typing import Optional, Union
from typing_extensions import TypeAliasType, TypedDict


class DetailTypedDict(TypedDict):
    pass


class Detail(BaseModel):
    pass


DetailUnionTypedDict = TypeAliasType(
    "DetailUnionTypedDict", Union[DetailTypedDict, str]
)
r"""Contains parameter or domain specific information related to the error and why it occurred."""


DetailUnion = TypeAliasType("DetailUnion", Union[Detail, str])
r"""Contains parameter or domain specific information related to the error and why it occurred."""


class BadRequestResponseErrorData(BaseModel):
    status_code: Optional[float] = None
    r"""HTTP status code"""

    error: Optional[str] = None
    r"""Contains an explanation of the status_code as defined in HTTP/1.1 standard (RFC 7231)"""

    type_name: Optional[str] = None
    r"""The type of error returned"""

    message: Optional[str] = None
    r"""A human-readable message providing more details about the error."""

    detail: Optional[DetailUnion] = None
    r"""Contains parameter or domain specific information related to the error and why it occurred."""

    ref: Optional[str] = None
    r"""Link to documentation of error type"""


class BadRequestResponseError(SDKBaseError):
    r"""Bad Request"""

    data: BadRequestResponseErrorData

    def __init__(
        self,
        data: BadRequestResponseErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
