"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from datetime import date
from decimal import Decimal
import io
import os
import pytest
import speakeasy.new_openapi
from speakeasy.new_openapi import SDK
from speakeasy.new_openapi.utils import parse_datetime
from tests import test_helpers
from tests.test_client import create_test_http_client
from tests.test_helpers import authenticate, user_setup, user_teardown


@pytest.mark.skip(
    reason="incomplete test found please make sure to address the following errors: [`workflow step testEndpoint.test referencing operation testEndpoint is missing required request body`, `workflow step testEndpoint.test referencing operation testEndpoint missing required path parameter testName`]"
)
def test_sdk_test_endpoint():
    pass


def test_sdk_get_user_test_with_status_code_only():
    test_http_client = create_test_http_client("getUser-testWithStatusCodeOnly")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_user(id="test123")
        assert res is not None


def test_sdk_get_user_test_with_response_body():
    test_http_client = create_test_http_client("getUser-testWithResponseBody")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_user(id="test123")
        assert res is not None
        assert res == speakeasy.new_openapi.User(
            id="test123",
            email="Trystan_Crooks@hotmail.com",
            first_name="Trystan",
            last_name="Crooks",
            age=32,
            postal_code="94110",
            metadata=speakeasy.new_openapi.Metadata(
                allergies="none",
                **{
                    "color": "red",
                    "height": "182",
                    "weight": "77",
                    "is_smoking": "true",
                },
            ),
        )


def test_sdk_get_user_test_with_response_body_fields():
    test_http_client = create_test_http_client("getUser-testWithResponseBodyFields")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_user(id="test123")
        assert res is not None
        assert res.metadata is not None
        assert res.metadata.allergies is not None
        assert res.metadata.allergies == "none"
        assert res.metadata.additional_properties["color"] == "red"
        assert res.associated_ids is not None
        assert res.associated_ids[1] == "test123"


def test_sdk_get_fully_flattened_request_named_example_that_isnt_matched_across_different_examples():
    test_http_client = create_test_http_client(
        "getFullyFlattenedRequest-namedExampleThatIsntMatchedAcrossDifferentExamples"
    )

    with SDK(
        server_url=os.getenv("TEST_URL", ""),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        sdk.get_fully_flattened_request(lang="en", name="<value>")


def test_sdk_post_file():
    test_http_client = create_test_http_client("postFile")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.post_file(
            request={
                "file": {
                    "file_name": "postfiletest.txt",
                    "content": open(".speakeasy/testfiles/postfiletest.txt", "rb"),
                },
            }
        )
        assert res is not None
        assert (
            bytes().join(res.iter_bytes()) == io.BytesIO("0x8fBAEeAAE7".encode()).read()
        )


def test_sdk_get_polymorphism():
    test_http_client = create_test_http_client("getPolymorphism")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_polymorphism()
        assert res is not None
        assert res == speakeasy.new_openapi.GetPolymorphismResponse(
            one_of_with_union_description=speakeasy.new_openapi.ExhaustiveObject(
                str_="example",
                bool_=True,
                integer=999999,
                int32=1,
                num=1.1,
                float32=7754.37,
                enum_prop=speakeasy.new_openapi.EnumT.FIRST,
                date_=date.fromisoformat("2022-04-06"),
                date_time=parse_datetime("2020-01-01T00:00:00Z"),
                anything="<value>",
                bool_opt=True,
                int_opt_null=999999,
                num_opt_null=1.1,
                int_enum=speakeasy.new_openapi.IntEnum.THIRD,
                int32_enum=speakeasy.new_openapi.Int32Enum.SIXTY_NINE,
                bigint=815677,
                bigint_str=12345678901234567890,
                decimal_str=Decimal("7753.11"),
                obj=speakeasy.new_openapi.SimpleObject(
                    str_="example",
                ),
                map={},
                arr=[
                    speakeasy.new_openapi.SimpleObject(
                        str_="example",
                    ),
                    speakeasy.new_openapi.SimpleObject(
                        str_="example",
                    ),
                    speakeasy.new_openapi.SimpleObject(
                        str_="example",
                    ),
                ],
                any="<value>",
                type="0",
                nullable_int_enum=speakeasy.new_openapi.NullableIntEnum.THIRD,
                nullable_string_enum=speakeasy.new_openapi.NullableStringEnum.FIRST,
                color="green",
                icon=speakeasy.new_openapi.Icon.TICK,
                hero_width=speakeasy.new_openapi.HeroWidth.FOUR_HUNDRED_AND_EIGHTY,
            ),
            one_of_with_factored_out_properties=speakeasy.new_openapi.OneOfWithFactoredOutPropertiesSimpleObject(
                str_="example",
                an_extra_property="example",
            ),
            simple_all_of=speakeasy.new_openapi.SimpleAllOf(
                str_="example",
                bool_=True,
            ),
            all_of_with_factored_out_properties=speakeasy.new_openapi.AllOfWithFactoredOutProperties(
                an_overriding_property="example",
                another_property="example",
                an_extra_property="example",
            ),
        )


def test_sdk_get_union_errors():
    test_http_client = create_test_http_client("getUnionErrors")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_union_errors(page=12)
        assert res is not None
        assert res.result is not None
        assert res.result == speakeasy.new_openapi.GetUnionErrorsResponseBody(
            pages=[],
        )


def test_sdk_get_request_body_flattened_away():
    test_http_client = create_test_http_client("getRequestBodyFlattenedAway")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        lone_query_param="<value>",
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        sdk.get_request_body_flattened_away()


def test_sdk_get_user_success():
    test_http_client = create_test_http_client("getUser-success")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_user(id="<id>")
        assert res is not None
        assert res == speakeasy.new_openapi.User(
            id="8ffac18c-7d88-4879-b057-e5f45b9ce7dg",
            email="Trystan_Crooks@hotmail.com",
        )


@pytest.mark.skip(
    reason="incomplete test found please make sure to address the following errors: [`workflow step chat.test referencing operation chat is not currently supported`]"
)
def test_sdk_chat():
    pass


def test_sdk_get_binary_default_response():
    test_http_client = create_test_http_client("getBinaryDefaultResponse")

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        res = sdk.get_binary_default_response()
        assert res is not None
        assert (
            bytes().join(res.iter_bytes()) == io.BytesIO("0xf58AcDF799".encode()).read()
        )


def test_sdk_user_lifecycle():
    test_http_client = create_test_http_client("user-lifecycle")

    authenticate_outputs = authenticate()
    assert authenticate_outputs is not None

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        security=speakeasy.new_openapi.Security(
            option7=speakeasy.new_openapi.SecurityOption7(
                api_key=authenticate_outputs.token,
            ),
        ),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        create_res = sdk.create_user(
            request=speakeasy.new_openapi.BaseUser(
                email="Trystan_Crooks@hotmail.com",
                first_name="Trystan",
                last_name="Crooks",
                age=32,
                postal_code="94110",
                metadata=speakeasy.new_openapi.Metadata(
                    allergies="none",
                    **{
                        "color": "red",
                        "height": "182",
                        "weight": "77",
                        "is_smoking": "true",
                    },
                ),
            )
        )
        assert create_res is not None
        assert create_res.email == "Trystan_Crooks@hotmail.com"
        assert create_res.postal_code is not None
        assert create_res.postal_code == "94110"

        assert sdk is not None

        get_res = sdk.get_user(id=create_res.id)
        assert get_res is not None
        assert get_res.email == "Trystan_Crooks@hotmail.com"
        assert get_res.first_name is not None
        assert get_res.first_name == "Trystan"
        assert get_res.last_name is not None
        assert get_res.last_name == "Crooks"
        assert get_res.age is not None
        assert get_res.age == 32
        assert get_res.postal_code is not None
        assert get_res.postal_code == "94110"

        assert sdk is not None

        user = get_res
        user.postal_code = "94107"
        user.age = get_res.age

        update_res = sdk.update_user(id=create_res.id, user=user)
        assert update_res is not None
        assert update_res.email == "Trystan_Crooks@hotmail.com"
        assert update_res.first_name is not None
        assert update_res.first_name == "Trystan"
        assert update_res.last_name is not None
        assert update_res.last_name == "Crooks"
        assert update_res.age is not None
        assert update_res.age == 32
        assert update_res.postal_code is not None
        assert update_res.postal_code == "94107"

        assert sdk is not None

        update_again_res = sdk.update_user(
            id=create_res.id,
            user=speakeasy.new_openapi.User(
                id=create_res.id,
                email=update_res.email,
                first_name=update_res.first_name,
                last_name=update_res.last_name,
                age=33,
                postal_code="94110",
                metadata=update_res.metadata,
            ),
        )
        assert update_again_res is not None
        assert update_again_res.email == "Trystan_Crooks@hotmail.com"
        assert update_again_res.first_name is not None
        assert update_again_res.first_name == "Trystan"
        assert update_again_res.last_name is not None
        assert update_again_res.last_name == "Crooks"
        assert update_again_res.age is not None
        assert update_again_res.age == 33
        assert update_again_res.postal_code is not None
        assert update_again_res.postal_code == "94110"

        assert sdk is not None

        sdk.delete_user(id=create_res.id)


def test_sdk_update_user():
    test_http_client = create_test_http_client("updateUser")

    setup_outputs = user_setup()
    assert setup_outputs is not None

    with SDK(
        server_url=os.getenv("TEST_SERVER_URL", "http://localhost:18080"),
        client=test_http_client,
    ) as sdk:
        assert sdk is not None

        user = setup_outputs.user
        user.postal_code = "94107"
        user.age = 33

        res = sdk.update_user(id=setup_outputs.user.id, user=user)
        assert res is not None
        assert res.email == "Trystan_Crooks@hotmail.com"
        assert res.first_name is not None
        assert res.first_name == "Trystan"
        assert res.last_name is not None
        assert res.last_name == "Crooks"
        assert res.age is not None
        assert res.age == 33
        assert res.postal_code is not None
        assert res.postal_code == "94107"

        user_teardown(
            test_helpers.UserTeardownInputs(
                id=setup_outputs.user.id,
            )
        )
