"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .errortype1 import ErrorType1Data
from .errortype2 import ErrorType2Data
from .taggederror1 import TaggedError1Data
from .taggederror2 import TaggedError2Data
import httpx
from pydantic import Discriminator, Tag
from speakeasy.new_openapi.models import SDKBaseError
from speakeasy.new_openapi.types import BaseModel
from speakeasy.new_openapi.utils import (
    FieldMetadata,
    QueryParamMetadata,
    get_discriminator,
)
from typing import Callable, List, Optional, Union
from typing_extensions import Annotated, TypeAliasType, TypedDict


class GetUnionErrorsRequestTypedDict(TypedDict):
    page: int


class GetUnionErrorsRequest(BaseModel):
    page: Annotated[
        int, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]


ClientErrorUnion = Annotated[
    Union[
        Annotated[TaggedError1Data, Tag("tag1")],
        Annotated[TaggedError2Data, Tag("tag2")],
    ],
    Discriminator(lambda m: get_discriminator(m, "tag", "tag")),
]
r"""Something went wrong"""


class ClientError(SDKBaseError):
    r"""Something went wrong"""

    data: ClientErrorUnion

    def __init__(
        self,
        data: ClientErrorUnion,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


GetUnionErrorsInternalServerErrorUnion = TypeAliasType(
    "GetUnionErrorsInternalServerErrorUnion", Union[ErrorType1Data, ErrorType2Data]
)
r"""Internal Server Error"""


class GetUnionErrorsInternalServerError(SDKBaseError):
    r"""Internal Server Error"""

    data: GetUnionErrorsInternalServerErrorUnion

    def __init__(
        self,
        data: GetUnionErrorsInternalServerErrorUnion,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetUnionErrorsResponseBodyTypedDict(TypedDict):
    r"""OK"""

    pages: List[str]


class GetUnionErrorsResponseBody(BaseModel):
    r"""OK"""

    pages: List[str]


class GetUnionErrorsResponseTypedDict(TypedDict):
    result: GetUnionErrorsResponseBodyTypedDict


class GetUnionErrorsResponse(BaseModel):
    next: Callable[[], Optional[GetUnionErrorsResponse]]

    result: GetUnionErrorsResponseBody
