"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .color import Color
from .enum import EnumT
from .simpleobject import SimpleObject, SimpleObjectTypedDict
from datetime import date, datetime
from decimal import Decimal
from enum import Enum
import pydantic
from pydantic.functional_serializers import PlainSerializer
from pydantic.functional_validators import (
    AfterValidator,
    BeforeValidator,
    PlainValidator,
)
from speakeasy.new_openapi import utils
from speakeasy.new_openapi.types import BaseModel
from speakeasy.new_openapi.utils import (
    serialize_decimal,
    serialize_int,
    validate_const,
    validate_decimal,
    validate_int,
    validate_open_enum,
)
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class OneOfWithFactoredOutPropertiesSimpleObjectTypedDict(TypedDict):
    str_: str
    r"""A string property."""
    an_extra_property: NotRequired[str]
    r"""An extra property."""


class OneOfWithFactoredOutPropertiesSimpleObject(BaseModel):
    str_: Annotated[str, pydantic.Field(alias="str")]
    r"""A string property."""

    an_extra_property: Annotated[
        Optional[str], pydantic.Field(alias="anExtraProperty")
    ] = None
    r"""An extra property."""


class OneOfWithFactoredOutPropertiesIntEnum(int, Enum):
    r"""An integer enum property."""

    FIRST = 1
    SECOND = 2
    THIRD = 3


class OneOfWithFactoredOutPropertiesInt32Enum(int, Enum):
    r"""An int32 enum property."""

    FIFTY_FIVE = 55
    SIXTY_NINE = 69
    ONE_HUNDRED_AND_EIGHTY_ONE = 181


OneOfWithFactoredOutPropertiesAnyTypedDict = TypeAliasType(
    "OneOfWithFactoredOutPropertiesAnyTypedDict", Union[SimpleObjectTypedDict, str]
)


OneOfWithFactoredOutPropertiesAny = TypeAliasType(
    "OneOfWithFactoredOutPropertiesAny", Union[SimpleObject, str]
)


class OneOfWithFactoredOutPropertiesNullableIntEnum(int, Enum):
    FIRST = 1
    SECOND = 2
    THIRD = 3


class OneOfWithFactoredOutPropertiesNullableStringEnum(str, Enum):
    FIRST = "First"
    SECOND = "Second"
    THIRD = "Third"


class OneOfWithFactoredOutPropertiesIcon(str, Enum):
    TICK = "tick"
    THUMBS_UP = "thumbs-up"
    FIRE = "fire"


class OneOfWithFactoredOutPropertiesHeroWidth(int, Enum, metaclass=utils.OpenEnumMeta):
    FOUR_HUNDRED_AND_EIGHTY = 480
    SEVEN_HUNDRED_AND_TWENTY = 720
    ONE_THOUSAND_AND_EIGHTY = 1080


class OneOfWithFactoredOutPropertiesExhaustiveObjectTypedDict(TypedDict):
    r"""A simple object that uses all our supported primitive types and enums and has optional properties.
    https://speakeasy.com - A link to the external docs.
    """

    str_: str
    r"""A string property."""
    bool_: bool
    r"""A boolean property."""
    integer: int
    r"""An integer property."""
    int32: int
    r"""An int32 property."""
    num: float
    r"""A number property."""
    float32: float
    r"""A float32 property."""
    date_: date
    r"""A date property."""
    date_time: datetime
    r"""A date-time property."""
    anything: Any
    r"""An any property."""
    int32_enum: OneOfWithFactoredOutPropertiesInt32Enum
    r"""An int32 enum property."""
    bigint: int
    decimal_str: Decimal
    obj: SimpleObjectTypedDict
    map: Dict[str, SimpleObjectTypedDict]
    arr: List[SimpleObjectTypedDict]
    any: OneOfWithFactoredOutPropertiesAnyTypedDict
    nullable_string_enum: OneOfWithFactoredOutPropertiesNullableStringEnum
    icon: OneOfWithFactoredOutPropertiesIcon
    enum_prop: NotRequired[EnumT]
    str_opt: NotRequired[str]
    r"""An optional string property."""
    bool_opt: NotRequired[bool]
    r"""An optional boolean property."""
    int_opt_null: NotRequired[int]
    r"""An optional integer property will be null for tests."""
    num_opt_null: NotRequired[float]
    r"""An optional number property will be null for tests."""
    int_enum: NotRequired[OneOfWithFactoredOutPropertiesIntEnum]
    r"""An integer enum property."""
    bigint_str: NotRequired[int]
    decimal: Decimal
    type: NotRequired[str]
    some_property_with_dots: NotRequired[str]
    r"""A property with dots."""
    nullable_int_enum: NotRequired[OneOfWithFactoredOutPropertiesNullableIntEnum]
    color: NotRequired[Color]
    hero_width: NotRequired[OneOfWithFactoredOutPropertiesHeroWidth]
    an_extra_property: NotRequired[str]
    r"""An extra property."""


class OneOfWithFactoredOutPropertiesExhaustiveObject(BaseModel):
    r"""A simple object that uses all our supported primitive types and enums and has optional properties.
    https://speakeasy.com - A link to the external docs.
    """

    str_: Annotated[str, pydantic.Field(alias="str")]
    r"""A string property."""

    bool_: Annotated[bool, pydantic.Field(alias="bool")]
    r"""A boolean property."""

    integer: Annotated[int, pydantic.Field(alias="int")]
    r"""An integer property."""

    int32: int
    r"""An int32 property."""

    num: float
    r"""A number property."""

    float32: float
    r"""A float32 property."""

    date_: Annotated[date, pydantic.Field(alias="date")]
    r"""A date property."""

    date_time: Annotated[datetime, pydantic.Field(alias="dateTime")]
    r"""A date-time property."""

    anything: Any
    r"""An any property."""

    int32_enum: Annotated[
        OneOfWithFactoredOutPropertiesInt32Enum, pydantic.Field(alias="int32Enum")
    ]
    r"""An int32 enum property."""

    bigint: Annotated[int, BeforeValidator(validate_int)]

    decimal_str: Annotated[
        Annotated[
            Decimal,
            BeforeValidator(validate_decimal),
            PlainSerializer(serialize_decimal(True)),
        ],
        pydantic.Field(alias="decimalStr"),
    ]

    obj: SimpleObject

    map: Dict[str, SimpleObject]

    arr: List[SimpleObject]

    any: OneOfWithFactoredOutPropertiesAny

    nullable_string_enum: Annotated[
        OneOfWithFactoredOutPropertiesNullableStringEnum,
        pydantic.Field(alias="nullableStringEnum"),
    ]

    icon: OneOfWithFactoredOutPropertiesIcon

    enum_prop: Annotated[Optional[EnumT], pydantic.Field(alias="enumProp")] = (
        EnumT.FIRST
    )

    str_opt: Annotated[Optional[str], pydantic.Field(alias="strOpt")] = None
    r"""An optional string property."""

    bool_opt: Annotated[Optional[bool], pydantic.Field(alias="boolOpt")] = None
    r"""An optional boolean property."""

    int_opt_null: Annotated[Optional[int], pydantic.Field(alias="intOptNull")] = None
    r"""An optional integer property will be null for tests."""

    num_opt_null: Annotated[Optional[float], pydantic.Field(alias="numOptNull")] = None
    r"""An optional number property will be null for tests."""

    int_enum: Annotated[
        Optional[OneOfWithFactoredOutPropertiesIntEnum], pydantic.Field(alias="intEnum")
    ] = OneOfWithFactoredOutPropertiesIntEnum.SECOND
    r"""An integer enum property."""

    bigint_str: Annotated[
        Annotated[
            Optional[int],
            BeforeValidator(validate_int),
            PlainSerializer(serialize_int(True)),
        ],
        pydantic.Field(alias="bigintStr"),
    ] = 12345678901234567890

    DECIMAL: Annotated[
        Annotated[
            Optional[Decimal],
            BeforeValidator(validate_decimal),
            AfterValidator(validate_const(Decimal("3.141592653589"))),
            PlainSerializer(serialize_decimal(False)),
        ],
        pydantic.Field(alias="decimal"),
    ] = Decimal("3.141592653589")

    type: Optional[str] = "0"

    some_property_with_dots: Annotated[
        Optional[str], pydantic.Field(alias="some.property.with.dots")
    ] = None
    r"""A property with dots."""

    nullable_int_enum: Annotated[
        Optional[OneOfWithFactoredOutPropertiesNullableIntEnum],
        pydantic.Field(alias="nullableIntEnum"),
    ] = OneOfWithFactoredOutPropertiesNullableIntEnum.SECOND

    color: Annotated[Optional[Color], PlainValidator(validate_open_enum(False))] = (
        "blue"
    )

    hero_width: Annotated[
        Annotated[
            Optional[OneOfWithFactoredOutPropertiesHeroWidth],
            PlainValidator(validate_open_enum(True)),
        ],
        pydantic.Field(alias="heroWidth"),
    ] = None

    an_extra_property: Annotated[
        Optional[str], pydantic.Field(alias="anExtraProperty")
    ] = None
    r"""An extra property."""


OneOfWithFactoredOutPropertiesTypedDict = TypeAliasType(
    "OneOfWithFactoredOutPropertiesTypedDict",
    Union[
        OneOfWithFactoredOutPropertiesSimpleObjectTypedDict,
        OneOfWithFactoredOutPropertiesExhaustiveObjectTypedDict,
    ],
)
r"""A union of two types with factored out properties."""


OneOfWithFactoredOutProperties = TypeAliasType(
    "OneOfWithFactoredOutProperties",
    Union[
        OneOfWithFactoredOutPropertiesSimpleObject,
        OneOfWithFactoredOutPropertiesExhaustiveObject,
    ],
)
r"""A union of two types with factored out properties."""
