"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
import httpx
import pydantic
from pydantic.functional_validators import AfterValidator
from speakeasy.new_openapi.models import SDKBaseError
from speakeasy.new_openapi.types import BaseModel
from speakeasy.new_openapi.utils import validate_const
from typing import Literal, Optional
from typing_extensions import Annotated, TypedDict


class TaggedError2ErrorTypedDict(TypedDict):
    message: str


class TaggedError2Error(BaseModel):
    message: str


class TaggedError2Data(BaseModel):
    error: TaggedError2Error

    TAG: Annotated[
        Annotated[Literal["tag2"], AfterValidator(validate_const("tag2"))],
        pydantic.Field(alias="tag"),
    ] = "tag2"


class TaggedError2(SDKBaseError):
    data: TaggedError2Data

    def __init__(
        self,
        data: TaggedError2Data,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        self.data = data
