"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from speakeasy.new_openapi import models, utils
from speakeasy.new_openapi._hooks import HookContext
from speakeasy.new_openapi.types import OptionalNullable, UNSET
from speakeasy.new_openapi.utils import get_security_from_env
from speakeasy.new_openapi.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Mapping, Optional, Union


class Tag2(BaseSDK):
    def post_test(
        self,
        *,
        test2_request: Union[models.Test2Request, models.Test2RequestTypedDict],
        deprecated_query_param1: Optional[str] = None,
        deprecated_query_param2: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[bytes]:
        r"""Post Test2

        This is a test endpoint.
        It has a description.

        :param test2_request:
        :param deprecated_query_param1:
        :param deprecated_query_param2:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.POST_TEST2_OP_SERVERS[models.POST_TEST2_OP_SERVER_DEFAULT]
            url_variables = {
                "port": "35123",
                "hostname": "localhost",
            }

        request = models.PostTest2Request(
            deprecated_query_param1=deprecated_query_param1,
            deprecated_query_param2=deprecated_query_param2,
            test2_request=utils.get_pydantic_model(test2_request, models.Test2Request),
        )

        req = self._build_request(
            method="POST",
            path="/test2",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="multipart/form-data",
            http_headers=http_headers,
            _globals=models.PostTest2Globals(
                deprecated_query_param1=self.sdk_configuration.globals.deprecated_query_param1,
                deprecated_query_param2=self.sdk_configuration.globals.deprecated_query_param2,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.test2_request, False, False, "json", models.Test2Request
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(10, 200, 1.5, 1000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["404"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="postTest2",
                oauth2_scopes=["read"],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "multipart/form-data"):
            http_res_bytes = utils.stream_to_bytes(http_res)
            return http_res_bytes
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseErrorData, http_res
            )
            raise models.BadRequestResponseError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(models.ErrorsErrorData, http_res)
            raise models.ErrorsError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                models.Test2ResponseErrorData, http_res
            )
            raise models.Test2ResponseError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "*"):
            return None

        raise models.SDKError("Unexpected response received", http_res)

    async def post_test_async(
        self,
        *,
        test2_request: Union[models.Test2Request, models.Test2RequestTypedDict],
        deprecated_query_param1: Optional[str] = None,
        deprecated_query_param2: Optional[str] = None,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[bytes]:
        r"""Post Test2

        This is a test endpoint.
        It has a description.

        :param test2_request:
        :param deprecated_query_param1:
        :param deprecated_query_param2:
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if server_url is not None:
            base_url = server_url
        else:
            base_url = models.POST_TEST2_OP_SERVERS[models.POST_TEST2_OP_SERVER_DEFAULT]
            url_variables = {
                "port": "35123",
                "hostname": "localhost",
            }

        request = models.PostTest2Request(
            deprecated_query_param1=deprecated_query_param1,
            deprecated_query_param2=deprecated_query_param2,
            test2_request=utils.get_pydantic_model(test2_request, models.Test2Request),
        )

        req = self._build_request_async(
            method="POST",
            path="/test2",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="multipart/form-data",
            http_headers=http_headers,
            _globals=models.PostTest2Globals(
                deprecated_query_param1=self.sdk_configuration.globals.deprecated_query_param1,
                deprecated_query_param2=self.sdk_configuration.globals.deprecated_query_param2,
            ),
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.test2_request, False, False, "json", models.Test2Request
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(10, 200, 1.5, 1000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["404"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="postTest2",
                oauth2_scopes=["read"],
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=["400", "404", "4XX", "500", "5XX"],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "multipart/form-data"):
            http_res_bytes = await utils.stream_to_bytes_async(http_res)
            return http_res_bytes
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                models.BadRequestResponseErrorData, http_res
            )
            raise models.BadRequestResponseError(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(models.ErrorsErrorData, http_res)
            raise models.ErrorsError(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                models.Test2ResponseErrorData, http_res
            )
            raise models.Test2ResponseError(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise models.SDKError("API error occurred", http_res, http_res_text)
        if utils.match_response(http_res, "default", "*"):
            return None

        raise models.SDKError("Unexpected response received", http_res)
