import { EdgeFunction, LogLevel } from '@cloudcomponents/cdk-lambda-at-edge-pattern';
import { aws_cognito } from 'aws-cdk-lib';
import { Construct } from 'constructs';
export interface RedirectPaths {
    readonly signIn: string;
    readonly authRefresh: string;
    readonly signOut: string;
}
export interface AuthFlowProps {
    readonly logLevel: LogLevel;
    readonly userPool: aws_cognito.IUserPool;
    readonly userPoolClient: aws_cognito.IUserPoolClient;
    readonly cognitoAuthDomain: string;
    readonly redirectPaths: RedirectPaths;
    readonly oauthScopes: aws_cognito.OAuthScope[];
    readonly cookieSettings: Record<string, string>;
    readonly nonceSigningSecret: string;
    readonly clientSecret?: string;
}
export declare class AuthFlow extends Construct {
    readonly checkAuth: EdgeFunction;
    readonly parseAuth: EdgeFunction;
    readonly refreshAuth: EdgeFunction;
    readonly signOut: EdgeFunction;
    constructor(scope: Construct, id: string, props: AuthFlowProps);
}
