"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mode = exports.StaticSiteAuthorization = exports.SpaAuthorization = exports.Authorization = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_lambda_at_edge_pattern_1 = require("@cloudcomponents/cdk-lambda-at-edge-pattern");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const auth_flow_1 = require("./auth-flow");
const retrieve_user_pool_client_secret_1 = require("./retrieve-user-pool-client-secret");
const secret_generator_1 = require("./secret-generator");
const user_pool_client_redirects_1 = require("./user-pool-client-redirects");
const user_pool_domain_1 = require("./user-pool-domain");
class Authorization extends constructs_1.Construct {
    constructor(scope, id, props) {
        var _d, _e, _f, _g, _h, _j, _k;
        super(scope, id);
        this.userPool = props.userPool;
        this.redirectPaths = (_d = props.redirectPaths) !== null && _d !== void 0 ? _d : {
            signIn: '/parseauth',
            authRefresh: '/refreshauth',
            signOut: '/',
        };
        this.signOutUrlPath = (_e = props.signOutUrl) !== null && _e !== void 0 ? _e : '/signout';
        this.responseHeaderPolicy = new aws_cdk_lib_1.aws_cloudfront.ResponseHeadersPolicy(this, 'ResponseHeadersPolicy', {
            securityHeadersBehavior: (_f = props.securityHeadersBehavior) !== null && _f !== void 0 ? _f : {
                contentSecurityPolicy: {
                    contentSecurityPolicy: "default-src 'none'; img-src 'self'; script-src 'self'; style-src 'self' 'unsafe-inline'; object-src 'none'; connect-src 'self'",
                    override: true,
                },
                contentTypeOptions: { override: true },
                frameOptions: { frameOption: aws_cdk_lib_1.aws_cloudfront.HeadersFrameOption.DENY, override: true },
                referrerPolicy: { referrerPolicy: aws_cdk_lib_1.aws_cloudfront.HeadersReferrerPolicy.SAME_ORIGIN, override: true },
                strictTransportSecurity: { accessControlMaxAge: aws_cdk_lib_1.Duration.seconds(31536000), includeSubdomains: true, preload: true, override: true },
                xssProtection: { protection: true, modeBlock: true, override: true },
            },
            customHeadersBehavior: {
                customHeaders: (_g = props.customHeaders) !== null && _g !== void 0 ? _g : [
                    {
                        header: 'Cache-Control',
                        value: 'no-cache',
                        override: true,
                    },
                ],
            },
        });
        this.oauthScopes = (_h = props.oauthScopes) !== null && _h !== void 0 ? _h : [
            aws_cdk_lib_1.aws_cognito.OAuthScope.PHONE,
            aws_cdk_lib_1.aws_cognito.OAuthScope.EMAIL,
            aws_cdk_lib_1.aws_cognito.OAuthScope.PROFILE,
            aws_cdk_lib_1.aws_cognito.OAuthScope.OPENID,
            aws_cdk_lib_1.aws_cognito.OAuthScope.COGNITO_ADMIN,
        ];
        this.cookieSettings = props.cookieSettings;
        this.identityProviders = (_j = props.identityProviders) !== null && _j !== void 0 ? _j : [aws_cdk_lib_1.aws_cognito.UserPoolClientIdentityProvider.COGNITO];
        this.userPoolClient = this.createUserPoolClient();
        this.nonceSigningSecret = this.generateNonceSigningSecret();
        this.cognitoAuthDomain = this.retrieveCognitoAuthDomain();
        this.authFlow = this.createAuthFlow((_k = props.logLevel) !== null && _k !== void 0 ? _k : cdk_lambda_at_edge_pattern_1.LogLevel.WARN);
    }
    updateUserPoolClientCallbacks(redirects) {
        const { callbackUrls, logoutUrls } = redirects;
        new user_pool_client_redirects_1.UserPoolClientRedirects(this, 'UserPoolClientRedirects', {
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            callbackUrls,
            logoutUrls,
            identityProviders: this.identityProviders,
        });
    }
    createDefaultBehavior(origin, options) {
        return {
            origin,
            compress: true,
            originRequestPolicy: aws_cdk_lib_1.aws_cloudfront.OriginRequestPolicy.ALL_VIEWER,
            viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            edgeLambdas: [this.authFlow.checkAuth],
            responseHeadersPolicy: this.responseHeaderPolicy,
            ...options,
        };
    }
    createAdditionalBehaviors(origin, options) {
        return {
            [this.redirectPaths.signIn]: {
                origin,
                compress: true,
                originRequestPolicy: aws_cdk_lib_1.aws_cloudfront.OriginRequestPolicy.ALL_VIEWER,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.parseAuth],
                ...options,
            },
            [this.redirectPaths.authRefresh]: {
                origin,
                compress: true,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.refreshAuth],
                ...options,
            },
            [this.signOutUrlPath]: {
                origin,
                compress: true,
                originRequestPolicy: aws_cdk_lib_1.aws_cloudfront.OriginRequestPolicy.ALL_VIEWER,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.signOut],
                ...options,
            },
        };
    }
    generateNonceSigningSecret() {
        const { secret } = new secret_generator_1.SecretGenerator(this, 'SecretGenerator');
        return secret;
    }
    retrieveCognitoAuthDomain() {
        const userPoolDomain = new user_pool_domain_1.UserPoolDomain(this, 'UserPoolDomain', {
            userPool: this.userPool,
        });
        return userPoolDomain.cognitoAuthDomain;
    }
}
exports.Authorization = Authorization;
_a = JSII_RTTI_SYMBOL_1;
Authorization[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.Authorization", version: "2.0.0" };
class SpaAuthorization extends Authorization {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.mode = Mode.SPA;
    }
    createUserPoolClient() {
        return this.userPool.addClient('UserPoolClient', {
            generateSecret: false,
            oAuth: {
                flows: {
                    authorizationCodeGrant: true,
                },
                scopes: this.oauthScopes,
            },
            supportedIdentityProviders: this.identityProviders,
            preventUserExistenceErrors: true,
        });
    }
    createAuthFlow(logLevel) {
        var _d;
        return new auth_flow_1.AuthFlow(this, 'AuthFlow', {
            logLevel,
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            redirectPaths: this.redirectPaths,
            nonceSigningSecret: this.nonceSigningSecret,
            cognitoAuthDomain: this.cognitoAuthDomain,
            cookieSettings: (_d = this.cookieSettings) !== null && _d !== void 0 ? _d : {
                idToken: 'Path=/; Secure; SameSite=Lax',
                accessToken: 'Path=/; Secure; SameSite=Lax',
                refreshToken: 'Path=/; Secure; SameSite=Lax',
                nonce: 'Path=/; Secure; HttpOnly; SameSite=Lax',
            },
        });
    }
}
exports.SpaAuthorization = SpaAuthorization;
_b = JSII_RTTI_SYMBOL_1;
SpaAuthorization[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaAuthorization", version: "2.0.0" };
class StaticSiteAuthorization extends Authorization {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.mode = Mode.STATIC_SITE;
    }
    createUserPoolClient() {
        return this.userPool.addClient('UserPoolClient', {
            generateSecret: true,
            oAuth: {
                flows: {
                    authorizationCodeGrant: true,
                },
                scopes: this.oauthScopes,
            },
            supportedIdentityProviders: this.identityProviders,
            preventUserExistenceErrors: true,
        });
    }
    createAuthFlow(logLevel) {
        var _d;
        const clientSecret = this.retrieveUserPoolClientSecret();
        return new auth_flow_1.AuthFlow(this, 'AuthFlow', {
            logLevel,
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            redirectPaths: this.redirectPaths,
            nonceSigningSecret: this.nonceSigningSecret,
            cognitoAuthDomain: this.cognitoAuthDomain,
            clientSecret,
            cookieSettings: (_d = this.cookieSettings) !== null && _d !== void 0 ? _d : {
                idToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                accessToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                refreshToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                nonce: 'Path=/; Secure; HttpOnly; SameSite=Lax',
            },
        });
    }
    retrieveUserPoolClientSecret() {
        const { clientSecret } = new retrieve_user_pool_client_secret_1.RetrieveUserPoolClientSecret(this, 'RetrieveUserPoolClientSecret', {
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
        });
        return clientSecret;
    }
}
exports.StaticSiteAuthorization = StaticSiteAuthorization;
_c = JSII_RTTI_SYMBOL_1;
StaticSiteAuthorization[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteAuthorization", version: "2.0.0" };
var Mode;
(function (Mode) {
    Mode["SPA"] = "SPA";
    Mode["STATIC_SITE"] = "STATIC_SITE";
})(Mode = exports.Mode || (exports.Mode = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXV0aG9yaXphdGlvbnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvYXV0aG9yaXphdGlvbnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw0RkFBdUU7QUFDdkUsNkNBQW9FO0FBQ3BFLDJDQUF1QztBQUV2QywyQ0FBc0Q7QUFDdEQseUZBQWtGO0FBQ2xGLHlEQUFxRDtBQUNyRCw2RUFBdUU7QUFDdkUseURBQW9EO0FBaUNwRCxNQUFzQixhQUFjLFNBQVEsc0JBQVM7SUFjbkQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF5Qjs7UUFDakUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixJQUFJLENBQUMsUUFBUSxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUM7UUFFL0IsSUFBSSxDQUFDLGFBQWEsU0FBRyxLQUFLLENBQUMsYUFBYSxtQ0FBSTtZQUMxQyxNQUFNLEVBQUUsWUFBWTtZQUNwQixXQUFXLEVBQUUsY0FBYztZQUMzQixPQUFPLEVBQUUsR0FBRztTQUNiLENBQUM7UUFFRixJQUFJLENBQUMsY0FBYyxTQUFHLEtBQUssQ0FBQyxVQUFVLG1DQUFJLFVBQVUsQ0FBQztRQUVyRCxJQUFJLENBQUMsb0JBQW9CLEdBQUcsSUFBSSw0QkFBYyxDQUFDLHFCQUFxQixDQUFDLElBQUksRUFBRSx1QkFBdUIsRUFBRTtZQUNsRyx1QkFBdUIsUUFBRSxLQUFLLENBQUMsdUJBQXVCLG1DQUFJO2dCQUN4RCxxQkFBcUIsRUFBRTtvQkFDckIscUJBQXFCLEVBQ25CLGdJQUFnSTtvQkFDbEksUUFBUSxFQUFFLElBQUk7aUJBQ2Y7Z0JBQ0Qsa0JBQWtCLEVBQUUsRUFBRSxRQUFRLEVBQUUsSUFBSSxFQUFFO2dCQUN0QyxZQUFZLEVBQUUsRUFBRSxXQUFXLEVBQUUsNEJBQWMsQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRTtnQkFDckYsY0FBYyxFQUFFLEVBQUUsY0FBYyxFQUFFLDRCQUFjLENBQUMscUJBQXFCLENBQUMsV0FBVyxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUU7Z0JBQ3BHLHVCQUF1QixFQUFFLEVBQUUsbUJBQW1CLEVBQUUsc0JBQVEsQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLEVBQUUsaUJBQWlCLEVBQUUsSUFBSSxFQUFFLE9BQU8sRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLElBQUksRUFBRTtnQkFDcEksYUFBYSxFQUFFLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsSUFBSSxFQUFFLFFBQVEsRUFBRSxJQUFJLEVBQUU7YUFDckU7WUFDRCxxQkFBcUIsRUFBRTtnQkFDckIsYUFBYSxRQUFFLEtBQUssQ0FBQyxhQUFhLG1DQUFJO29CQUNwQzt3QkFDRSxNQUFNLEVBQUUsZUFBZTt3QkFDdkIsS0FBSyxFQUFFLFVBQVU7d0JBQ2pCLFFBQVEsRUFBRSxJQUFJO3FCQUNmO2lCQUNGO2FBQ0Y7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsV0FBVyxTQUFHLEtBQUssQ0FBQyxXQUFXLG1DQUFJO1lBQ3RDLHlCQUFXLENBQUMsVUFBVSxDQUFDLEtBQUs7WUFDNUIseUJBQVcsQ0FBQyxVQUFVLENBQUMsS0FBSztZQUM1Qix5QkFBVyxDQUFDLFVBQVUsQ0FBQyxPQUFPO1lBQzlCLHlCQUFXLENBQUMsVUFBVSxDQUFDLE1BQU07WUFDN0IseUJBQVcsQ0FBQyxVQUFVLENBQUMsYUFBYTtTQUNyQyxDQUFDO1FBRUYsSUFBSSxDQUFDLGNBQWMsR0FBRyxLQUFLLENBQUMsY0FBYyxDQUFDO1FBRTNDLElBQUksQ0FBQyxpQkFBaUIsU0FBRyxLQUFLLENBQUMsaUJBQWlCLG1DQUFJLENBQUMseUJBQVcsQ0FBQyw4QkFBOEIsQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUV6RyxJQUFJLENBQUMsY0FBYyxHQUFHLElBQUksQ0FBQyxvQkFBb0IsRUFBRSxDQUFDO1FBRWxELElBQUksQ0FBQyxrQkFBa0IsR0FBRyxJQUFJLENBQUMsMEJBQTBCLEVBQUUsQ0FBQztRQUU1RCxJQUFJLENBQUMsaUJBQWlCLEdBQUcsSUFBSSxDQUFDLHlCQUF5QixFQUFFLENBQUM7UUFFMUQsSUFBSSxDQUFDLFFBQVEsR0FBRyxJQUFJLENBQUMsY0FBYyxPQUFDLEtBQUssQ0FBQyxRQUFRLG1DQUFJLHFDQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7SUFDdkUsQ0FBQztJQU1NLDZCQUE2QixDQUFDLFNBQXFDO1FBQ3hFLE1BQU0sRUFBRSxZQUFZLEVBQUUsVUFBVSxFQUFFLEdBQUcsU0FBUyxDQUFDO1FBRS9DLElBQUksb0RBQXVCLENBQUMsSUFBSSxFQUFFLHlCQUF5QixFQUFFO1lBQzNELFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLFlBQVk7WUFDWixVQUFVO1lBQ1YsaUJBQWlCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtTQUMxQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU0scUJBQXFCLENBQUMsTUFBOEIsRUFBRSxPQUEyQztRQUN0RyxPQUFPO1lBQ0wsTUFBTTtZQUNOLFFBQVEsRUFBRSxJQUFJO1lBQ2QsbUJBQW1CLEVBQUUsNEJBQWMsQ0FBQyxtQkFBbUIsQ0FBQyxVQUFVO1lBQ2xFLG9CQUFvQixFQUFFLDRCQUFjLENBQUMsb0JBQW9CLENBQUMsaUJBQWlCO1lBQzNFLFdBQVcsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDO1lBQ3RDLHFCQUFxQixFQUFFLElBQUksQ0FBQyxvQkFBb0I7WUFDaEQsR0FBRyxPQUFPO1NBQ1gsQ0FBQztJQUNKLENBQUM7SUFFTSx5QkFBeUIsQ0FDOUIsTUFBOEIsRUFDOUIsT0FBMkM7UUFFM0MsT0FBTztZQUNMLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxNQUFNLENBQUMsRUFBRTtnQkFDM0IsTUFBTTtnQkFDTixRQUFRLEVBQUUsSUFBSTtnQkFDZCxtQkFBbUIsRUFBRSw0QkFBYyxDQUFDLG1CQUFtQixDQUFDLFVBQVU7Z0JBQ2xFLG9CQUFvQixFQUFFLDRCQUFjLENBQUMsb0JBQW9CLENBQUMsaUJBQWlCO2dCQUMzRSxXQUFXLEVBQUUsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQztnQkFDdEMsR0FBRyxPQUFPO2FBQ1g7WUFDRCxDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsV0FBVyxDQUFDLEVBQUU7Z0JBQ2hDLE1BQU07Z0JBQ04sUUFBUSxFQUFFLElBQUk7Z0JBQ2Qsb0JBQW9CLEVBQUUsNEJBQWMsQ0FBQyxvQkFBb0IsQ0FBQyxpQkFBaUI7Z0JBQzNFLFdBQVcsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDO2dCQUN4QyxHQUFHLE9BQU87YUFDWDtZQUNELENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxFQUFFO2dCQUNyQixNQUFNO2dCQUNOLFFBQVEsRUFBRSxJQUFJO2dCQUNkLG1CQUFtQixFQUFFLDRCQUFjLENBQUMsbUJBQW1CLENBQUMsVUFBVTtnQkFDbEUsb0JBQW9CLEVBQUUsNEJBQWMsQ0FBQyxvQkFBb0IsQ0FBQyxpQkFBaUI7Z0JBQzNFLFdBQVcsRUFBRSxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsT0FBTyxDQUFDO2dCQUNwQyxHQUFHLE9BQU87YUFDWDtTQUNGLENBQUM7SUFDSixDQUFDO0lBRU8sMEJBQTBCO1FBQ2hDLE1BQU0sRUFBRSxNQUFNLEVBQUUsR0FBRyxJQUFJLGtDQUFlLENBQUMsSUFBSSxFQUFFLGlCQUFpQixDQUFDLENBQUM7UUFDaEUsT0FBTyxNQUFNLENBQUM7SUFDaEIsQ0FBQztJQUVPLHlCQUF5QjtRQUMvQixNQUFNLGNBQWMsR0FBRyxJQUFJLGlDQUFjLENBQUMsSUFBSSxFQUFFLGdCQUFnQixFQUFFO1lBQ2hFLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtTQUN4QixDQUFDLENBQUM7UUFFSCxPQUFPLGNBQWMsQ0FBQyxpQkFBaUIsQ0FBQztJQUMxQyxDQUFDOztBQS9JSCxzQ0FnSkM7OztBQVFELE1BQWEsZ0JBQWlCLFNBQVEsYUFBYTtJQUdqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBSFYsU0FBSSxHQUFHLElBQUksQ0FBQyxHQUFHLENBQUM7SUFJaEMsQ0FBQztJQUVTLG9CQUFvQjtRQUM1QixPQUFPLElBQUksQ0FBQyxRQUFRLENBQUMsU0FBUyxDQUFDLGdCQUFnQixFQUFFO1lBQy9DLGNBQWMsRUFBRSxLQUFLO1lBQ3JCLEtBQUssRUFBRTtnQkFDTCxLQUFLLEVBQUU7b0JBQ0wsc0JBQXNCLEVBQUUsSUFBSTtpQkFDN0I7Z0JBQ0QsTUFBTSxFQUFFLElBQUksQ0FBQyxXQUFXO2FBQ3pCO1lBQ0QsMEJBQTBCLEVBQUUsSUFBSSxDQUFDLGlCQUFpQjtZQUNsRCwwQkFBMEIsRUFBRSxJQUFJO1NBQ2pDLENBQUMsQ0FBQztJQUNMLENBQUM7SUFFUyxjQUFjLENBQUMsUUFBa0I7O1FBQ3pDLE9BQU8sSUFBSSxvQkFBUSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUU7WUFDcEMsUUFBUTtZQUNSLFFBQVEsRUFBRSxJQUFJLENBQUMsUUFBUTtZQUN2QixjQUFjLEVBQUUsSUFBSSxDQUFDLGNBQWM7WUFDbkMsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLGFBQWEsRUFBRSxJQUFJLENBQUMsYUFBYTtZQUNqQyxrQkFBa0IsRUFBRSxJQUFJLENBQUMsa0JBQWtCO1lBQzNDLGlCQUFpQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDekMsY0FBYyxRQUFFLElBQUksQ0FBQyxjQUFjLG1DQUFJO2dCQUNyQyxPQUFPLEVBQUUsOEJBQThCO2dCQUN2QyxXQUFXLEVBQUUsOEJBQThCO2dCQUMzQyxZQUFZLEVBQUUsOEJBQThCO2dCQUM1QyxLQUFLLEVBQUUsd0NBQXdDO2FBQ2hEO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQzs7QUFyQ0gsNENBc0NDOzs7QUFRRCxNQUFhLHVCQUF3QixTQUFRLGFBQWE7SUFHeEQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUFtQztRQUMzRSxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsRUFBRSxLQUFLLENBQUMsQ0FBQztRQUhWLFNBQUksR0FBRyxJQUFJLENBQUMsV0FBVyxDQUFDO0lBSXhDLENBQUM7SUFFUyxvQkFBb0I7UUFDNUIsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDLFNBQVMsQ0FBQyxnQkFBZ0IsRUFBRTtZQUMvQyxjQUFjLEVBQUUsSUFBSTtZQUNwQixLQUFLLEVBQUU7Z0JBQ0wsS0FBSyxFQUFFO29CQUNMLHNCQUFzQixFQUFFLElBQUk7aUJBQzdCO2dCQUNELE1BQU0sRUFBRSxJQUFJLENBQUMsV0FBVzthQUN6QjtZQUNELDBCQUEwQixFQUFFLElBQUksQ0FBQyxpQkFBaUI7WUFDbEQsMEJBQTBCLEVBQUUsSUFBSTtTQUNqQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRVMsY0FBYyxDQUFDLFFBQWtCOztRQUN6QyxNQUFNLFlBQVksR0FBRyxJQUFJLENBQUMsNEJBQTRCLEVBQUUsQ0FBQztRQUV6RCxPQUFPLElBQUksb0JBQVEsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ3BDLFFBQVE7WUFDUixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1lBQ25DLFdBQVcsRUFBRSxJQUFJLENBQUMsV0FBVztZQUM3QixhQUFhLEVBQUUsSUFBSSxDQUFDLGFBQWE7WUFDakMsa0JBQWtCLEVBQUUsSUFBSSxDQUFDLGtCQUFrQjtZQUMzQyxpQkFBaUIsRUFBRSxJQUFJLENBQUMsaUJBQWlCO1lBQ3pDLFlBQVk7WUFDWixjQUFjLFFBQUUsSUFBSSxDQUFDLGNBQWMsbUNBQUk7Z0JBQ3JDLE9BQU8sRUFBRSx3Q0FBd0M7Z0JBQ2pELFdBQVcsRUFBRSx3Q0FBd0M7Z0JBQ3JELFlBQVksRUFBRSx3Q0FBd0M7Z0JBQ3RELEtBQUssRUFBRSx3Q0FBd0M7YUFDaEQ7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0lBRU8sNEJBQTRCO1FBQ2xDLE1BQU0sRUFBRSxZQUFZLEVBQUUsR0FBRyxJQUFJLCtEQUE0QixDQUFDLElBQUksRUFBRSw4QkFBOEIsRUFBRTtZQUM5RixRQUFRLEVBQUUsSUFBSSxDQUFDLFFBQVE7WUFDdkIsY0FBYyxFQUFFLElBQUksQ0FBQyxjQUFjO1NBQ3BDLENBQUMsQ0FBQztRQUVILE9BQU8sWUFBWSxDQUFDO0lBQ3RCLENBQUM7O0FBakRILDBEQWtEQzs7O0FBRUQsSUFBWSxJQUdYO0FBSEQsV0FBWSxJQUFJO0lBQ2QsbUJBQVcsQ0FBQTtJQUNYLG1DQUEyQixDQUFBO0FBQzdCLENBQUMsRUFIVyxJQUFJLEdBQUosWUFBSSxLQUFKLFlBQUksUUFHZiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IExvZ0xldmVsIH0gZnJvbSAnQGNsb3VkY29tcG9uZW50cy9jZGstbGFtYmRhLWF0LWVkZ2UtcGF0dGVybic7XG5pbXBvcnQgeyBEdXJhdGlvbiwgYXdzX2Nsb3VkZnJvbnQsIGF3c19jb2duaXRvIH0gZnJvbSAnYXdzLWNkay1saWInO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmltcG9ydCB7IEF1dGhGbG93LCBSZWRpcmVjdFBhdGhzIH0gZnJvbSAnLi9hdXRoLWZsb3cnO1xuaW1wb3J0IHsgUmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldCB9IGZyb20gJy4vcmV0cmlldmUtdXNlci1wb29sLWNsaWVudC1zZWNyZXQnO1xuaW1wb3J0IHsgU2VjcmV0R2VuZXJhdG9yIH0gZnJvbSAnLi9zZWNyZXQtZ2VuZXJhdG9yJztcbmltcG9ydCB7IFVzZXJQb29sQ2xpZW50UmVkaXJlY3RzIH0gZnJvbSAnLi91c2VyLXBvb2wtY2xpZW50LXJlZGlyZWN0cyc7XG5pbXBvcnQgeyBVc2VyUG9vbERvbWFpbiB9IGZyb20gJy4vdXNlci1wb29sLWRvbWFpbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgVXNlclBvb2xDbGllbnRDYWxsYmFja1VybHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNhbGxiYWNrVXJsczogc3RyaW5nW107XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGxvZ291dFVybHM6IHN0cmluZ1tdO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIElBdXRob3JpemF0aW9uIHtcbiAgcmVhZG9ubHkgcmVkaXJlY3RQYXRoczogUmVkaXJlY3RQYXRocztcbiAgcmVhZG9ubHkgc2lnbk91dFVybFBhdGg6IHN0cmluZztcbiAgdXBkYXRlVXNlclBvb2xDbGllbnRDYWxsYmFja3MocmVkaXJlY3RzOiBVc2VyUG9vbENsaWVudENhbGxiYWNrVXJscyk6IHZvaWQ7XG4gIGNyZWF0ZURlZmF1bHRCZWhhdmlvcihvcmlnaW46IGF3c19jbG91ZGZyb250LklPcmlnaW4sIG9wdGlvbnM/OiBhd3NfY2xvdWRmcm9udC5BZGRCZWhhdmlvck9wdGlvbnMpOiBhd3NfY2xvdWRmcm9udC5CZWhhdmlvck9wdGlvbnM7XG4gIGNyZWF0ZUFkZGl0aW9uYWxCZWhhdmlvcnMoXG4gICAgb3JpZ2luOiBhd3NfY2xvdWRmcm9udC5JT3JpZ2luLFxuICAgIG9wdGlvbnM/OiBhd3NfY2xvdWRmcm9udC5BZGRCZWhhdmlvck9wdGlvbnMsXG4gICk6IFJlY29yZDxzdHJpbmcsIGF3c19jbG91ZGZyb250LkJlaGF2aW9yT3B0aW9ucz47XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgQXV0aG9yaXphdGlvblByb3BzIHtcbiAgcmVhZG9ubHkgdXNlclBvb2w6IGF3c19jb2duaXRvLklVc2VyUG9vbDtcbiAgcmVhZG9ubHkgcmVkaXJlY3RQYXRocz86IFJlZGlyZWN0UGF0aHM7XG4gIHJlYWRvbmx5IHNpZ25PdXRVcmw/OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGN1c3RvbUhlYWRlcnM/OiBhd3NfY2xvdWRmcm9udC5SZXNwb25zZUN1c3RvbUhlYWRlcltdO1xuICByZWFkb25seSBzZWN1cml0eUhlYWRlcnNCZWhhdmlvcj86IGF3c19jbG91ZGZyb250LlJlc3BvbnNlU2VjdXJpdHlIZWFkZXJzQmVoYXZpb3I7XG4gIHJlYWRvbmx5IGxvZ0xldmVsPzogTG9nTGV2ZWw7XG4gIHJlYWRvbmx5IG9hdXRoU2NvcGVzPzogYXdzX2NvZ25pdG8uT0F1dGhTY29wZVtdO1xuICByZWFkb25seSBjb29raWVTZXR0aW5ncz86IFJlY29yZDxzdHJpbmcsIHN0cmluZz47XG4gIHJlYWRvbmx5IGlkZW50aXR5UHJvdmlkZXJzPzogYXdzX2NvZ25pdG8uVXNlclBvb2xDbGllbnRJZGVudGl0eVByb3ZpZGVyW107XG59XG5cbmV4cG9ydCBhYnN0cmFjdCBjbGFzcyBBdXRob3JpemF0aW9uIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IHJlZGlyZWN0UGF0aHM6IFJlZGlyZWN0UGF0aHM7XG4gIHB1YmxpYyByZWFkb25seSBzaWduT3V0VXJsUGF0aDogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgYXV0aEZsb3c6IEF1dGhGbG93O1xuICBwdWJsaWMgcmVhZG9ubHkgdXNlclBvb2xDbGllbnQ6IGF3c19jb2duaXRvLklVc2VyUG9vbENsaWVudDtcblxuICBwcm90ZWN0ZWQgcmVhZG9ubHkgdXNlclBvb2w6IGF3c19jb2duaXRvLklVc2VyUG9vbDtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IG9hdXRoU2NvcGVzOiBhd3NfY29nbml0by5PQXV0aFNjb3BlW107XG4gIHByb3RlY3RlZCByZWFkb25seSBjb29raWVTZXR0aW5nczogUmVjb3JkPHN0cmluZywgc3RyaW5nPiB8IHVuZGVmaW5lZDtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IG5vbmNlU2lnbmluZ1NlY3JldDogc3RyaW5nO1xuICBwcm90ZWN0ZWQgcmVhZG9ubHkgY29nbml0b0F1dGhEb21haW46IHN0cmluZztcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IGlkZW50aXR5UHJvdmlkZXJzOiBhd3NfY29nbml0by5Vc2VyUG9vbENsaWVudElkZW50aXR5UHJvdmlkZXJbXTtcbiAgcHJvdGVjdGVkIHJlYWRvbmx5IHJlc3BvbnNlSGVhZGVyUG9saWN5OiBhd3NfY2xvdWRmcm9udC5JUmVzcG9uc2VIZWFkZXJzUG9saWN5O1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBBdXRob3JpemF0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgdGhpcy51c2VyUG9vbCA9IHByb3BzLnVzZXJQb29sO1xuXG4gICAgdGhpcy5yZWRpcmVjdFBhdGhzID0gcHJvcHMucmVkaXJlY3RQYXRocyA/PyB7XG4gICAgICBzaWduSW46ICcvcGFyc2VhdXRoJyxcbiAgICAgIGF1dGhSZWZyZXNoOiAnL3JlZnJlc2hhdXRoJyxcbiAgICAgIHNpZ25PdXQ6ICcvJyxcbiAgICB9O1xuXG4gICAgdGhpcy5zaWduT3V0VXJsUGF0aCA9IHByb3BzLnNpZ25PdXRVcmwgPz8gJy9zaWdub3V0JztcblxuICAgIHRoaXMucmVzcG9uc2VIZWFkZXJQb2xpY3kgPSBuZXcgYXdzX2Nsb3VkZnJvbnQuUmVzcG9uc2VIZWFkZXJzUG9saWN5KHRoaXMsICdSZXNwb25zZUhlYWRlcnNQb2xpY3knLCB7XG4gICAgICBzZWN1cml0eUhlYWRlcnNCZWhhdmlvcjogcHJvcHMuc2VjdXJpdHlIZWFkZXJzQmVoYXZpb3IgPz8ge1xuICAgICAgICBjb250ZW50U2VjdXJpdHlQb2xpY3k6IHtcbiAgICAgICAgICBjb250ZW50U2VjdXJpdHlQb2xpY3k6XG4gICAgICAgICAgICBcImRlZmF1bHQtc3JjICdub25lJzsgaW1nLXNyYyAnc2VsZic7IHNjcmlwdC1zcmMgJ3NlbGYnOyBzdHlsZS1zcmMgJ3NlbGYnICd1bnNhZmUtaW5saW5lJzsgb2JqZWN0LXNyYyAnbm9uZSc7IGNvbm5lY3Qtc3JjICdzZWxmJ1wiLFxuICAgICAgICAgIG92ZXJyaWRlOiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgICBjb250ZW50VHlwZU9wdGlvbnM6IHsgb3ZlcnJpZGU6IHRydWUgfSxcbiAgICAgICAgZnJhbWVPcHRpb25zOiB7IGZyYW1lT3B0aW9uOiBhd3NfY2xvdWRmcm9udC5IZWFkZXJzRnJhbWVPcHRpb24uREVOWSwgb3ZlcnJpZGU6IHRydWUgfSxcbiAgICAgICAgcmVmZXJyZXJQb2xpY3k6IHsgcmVmZXJyZXJQb2xpY3k6IGF3c19jbG91ZGZyb250LkhlYWRlcnNSZWZlcnJlclBvbGljeS5TQU1FX09SSUdJTiwgb3ZlcnJpZGU6IHRydWUgfSxcbiAgICAgICAgc3RyaWN0VHJhbnNwb3J0U2VjdXJpdHk6IHsgYWNjZXNzQ29udHJvbE1heEFnZTogRHVyYXRpb24uc2Vjb25kcygzMTUzNjAwMCksIGluY2x1ZGVTdWJkb21haW5zOiB0cnVlLCBwcmVsb2FkOiB0cnVlLCBvdmVycmlkZTogdHJ1ZSB9LFxuICAgICAgICB4c3NQcm90ZWN0aW9uOiB7IHByb3RlY3Rpb246IHRydWUsIG1vZGVCbG9jazogdHJ1ZSwgb3ZlcnJpZGU6IHRydWUgfSxcbiAgICAgIH0sXG4gICAgICBjdXN0b21IZWFkZXJzQmVoYXZpb3I6IHtcbiAgICAgICAgY3VzdG9tSGVhZGVyczogcHJvcHMuY3VzdG9tSGVhZGVycyA/PyBbXG4gICAgICAgICAge1xuICAgICAgICAgICAgaGVhZGVyOiAnQ2FjaGUtQ29udHJvbCcsXG4gICAgICAgICAgICB2YWx1ZTogJ25vLWNhY2hlJyxcbiAgICAgICAgICAgIG92ZXJyaWRlOiB0cnVlLFxuICAgICAgICAgIH0sXG4gICAgICAgIF0sXG4gICAgICB9LFxuICAgIH0pO1xuXG4gICAgdGhpcy5vYXV0aFNjb3BlcyA9IHByb3BzLm9hdXRoU2NvcGVzID8/IFtcbiAgICAgIGF3c19jb2duaXRvLk9BdXRoU2NvcGUuUEhPTkUsXG4gICAgICBhd3NfY29nbml0by5PQXV0aFNjb3BlLkVNQUlMLFxuICAgICAgYXdzX2NvZ25pdG8uT0F1dGhTY29wZS5QUk9GSUxFLFxuICAgICAgYXdzX2NvZ25pdG8uT0F1dGhTY29wZS5PUEVOSUQsXG4gICAgICBhd3NfY29nbml0by5PQXV0aFNjb3BlLkNPR05JVE9fQURNSU4sXG4gICAgXTtcblxuICAgIHRoaXMuY29va2llU2V0dGluZ3MgPSBwcm9wcy5jb29raWVTZXR0aW5ncztcblxuICAgIHRoaXMuaWRlbnRpdHlQcm92aWRlcnMgPSBwcm9wcy5pZGVudGl0eVByb3ZpZGVycyA/PyBbYXdzX2NvZ25pdG8uVXNlclBvb2xDbGllbnRJZGVudGl0eVByb3ZpZGVyLkNPR05JVE9dO1xuXG4gICAgdGhpcy51c2VyUG9vbENsaWVudCA9IHRoaXMuY3JlYXRlVXNlclBvb2xDbGllbnQoKTtcblxuICAgIHRoaXMubm9uY2VTaWduaW5nU2VjcmV0ID0gdGhpcy5nZW5lcmF0ZU5vbmNlU2lnbmluZ1NlY3JldCgpO1xuXG4gICAgdGhpcy5jb2duaXRvQXV0aERvbWFpbiA9IHRoaXMucmV0cmlldmVDb2duaXRvQXV0aERvbWFpbigpO1xuXG4gICAgdGhpcy5hdXRoRmxvdyA9IHRoaXMuY3JlYXRlQXV0aEZsb3cocHJvcHMubG9nTGV2ZWwgPz8gTG9nTGV2ZWwuV0FSTik7XG4gIH1cblxuICBwcm90ZWN0ZWQgYWJzdHJhY3QgY3JlYXRlVXNlclBvb2xDbGllbnQoKTogYXdzX2NvZ25pdG8uSVVzZXJQb29sQ2xpZW50O1xuXG4gIHByb3RlY3RlZCBhYnN0cmFjdCBjcmVhdGVBdXRoRmxvdyhsb2dMZXZlbDogTG9nTGV2ZWwpOiBBdXRoRmxvdztcblxuICBwdWJsaWMgdXBkYXRlVXNlclBvb2xDbGllbnRDYWxsYmFja3MocmVkaXJlY3RzOiBVc2VyUG9vbENsaWVudENhbGxiYWNrVXJscyk6IHZvaWQge1xuICAgIGNvbnN0IHsgY2FsbGJhY2tVcmxzLCBsb2dvdXRVcmxzIH0gPSByZWRpcmVjdHM7XG5cbiAgICBuZXcgVXNlclBvb2xDbGllbnRSZWRpcmVjdHModGhpcywgJ1VzZXJQb29sQ2xpZW50UmVkaXJlY3RzJywge1xuICAgICAgdXNlclBvb2w6IHRoaXMudXNlclBvb2wsXG4gICAgICB1c2VyUG9vbENsaWVudDogdGhpcy51c2VyUG9vbENsaWVudCxcbiAgICAgIG9hdXRoU2NvcGVzOiB0aGlzLm9hdXRoU2NvcGVzLFxuICAgICAgY2FsbGJhY2tVcmxzLFxuICAgICAgbG9nb3V0VXJscyxcbiAgICAgIGlkZW50aXR5UHJvdmlkZXJzOiB0aGlzLmlkZW50aXR5UHJvdmlkZXJzLFxuICAgIH0pO1xuICB9XG5cbiAgcHVibGljIGNyZWF0ZURlZmF1bHRCZWhhdmlvcihvcmlnaW46IGF3c19jbG91ZGZyb250LklPcmlnaW4sIG9wdGlvbnM/OiBhd3NfY2xvdWRmcm9udC5BZGRCZWhhdmlvck9wdGlvbnMpOiBhd3NfY2xvdWRmcm9udC5CZWhhdmlvck9wdGlvbnMge1xuICAgIHJldHVybiB7XG4gICAgICBvcmlnaW4sXG4gICAgICBjb21wcmVzczogdHJ1ZSxcbiAgICAgIG9yaWdpblJlcXVlc3RQb2xpY3k6IGF3c19jbG91ZGZyb250Lk9yaWdpblJlcXVlc3RQb2xpY3kuQUxMX1ZJRVdFUixcbiAgICAgIHZpZXdlclByb3RvY29sUG9saWN5OiBhd3NfY2xvdWRmcm9udC5WaWV3ZXJQcm90b2NvbFBvbGljeS5SRURJUkVDVF9UT19IVFRQUyxcbiAgICAgIGVkZ2VMYW1iZGFzOiBbdGhpcy5hdXRoRmxvdy5jaGVja0F1dGhdLFxuICAgICAgcmVzcG9uc2VIZWFkZXJzUG9saWN5OiB0aGlzLnJlc3BvbnNlSGVhZGVyUG9saWN5LFxuICAgICAgLi4ub3B0aW9ucyxcbiAgICB9O1xuICB9XG5cbiAgcHVibGljIGNyZWF0ZUFkZGl0aW9uYWxCZWhhdmlvcnMoXG4gICAgb3JpZ2luOiBhd3NfY2xvdWRmcm9udC5JT3JpZ2luLFxuICAgIG9wdGlvbnM/OiBhd3NfY2xvdWRmcm9udC5BZGRCZWhhdmlvck9wdGlvbnMsXG4gICk6IFJlY29yZDxzdHJpbmcsIGF3c19jbG91ZGZyb250LkJlaGF2aW9yT3B0aW9ucz4ge1xuICAgIHJldHVybiB7XG4gICAgICBbdGhpcy5yZWRpcmVjdFBhdGhzLnNpZ25Jbl06IHtcbiAgICAgICAgb3JpZ2luLFxuICAgICAgICBjb21wcmVzczogdHJ1ZSxcbiAgICAgICAgb3JpZ2luUmVxdWVzdFBvbGljeTogYXdzX2Nsb3VkZnJvbnQuT3JpZ2luUmVxdWVzdFBvbGljeS5BTExfVklFV0VSLFxuICAgICAgICB2aWV3ZXJQcm90b2NvbFBvbGljeTogYXdzX2Nsb3VkZnJvbnQuVmlld2VyUHJvdG9jb2xQb2xpY3kuUkVESVJFQ1RfVE9fSFRUUFMsXG4gICAgICAgIGVkZ2VMYW1iZGFzOiBbdGhpcy5hdXRoRmxvdy5wYXJzZUF1dGhdLFxuICAgICAgICAuLi5vcHRpb25zLFxuICAgICAgfSxcbiAgICAgIFt0aGlzLnJlZGlyZWN0UGF0aHMuYXV0aFJlZnJlc2hdOiB7XG4gICAgICAgIG9yaWdpbixcbiAgICAgICAgY29tcHJlc3M6IHRydWUsXG4gICAgICAgIHZpZXdlclByb3RvY29sUG9saWN5OiBhd3NfY2xvdWRmcm9udC5WaWV3ZXJQcm90b2NvbFBvbGljeS5SRURJUkVDVF9UT19IVFRQUyxcbiAgICAgICAgZWRnZUxhbWJkYXM6IFt0aGlzLmF1dGhGbG93LnJlZnJlc2hBdXRoXSxcbiAgICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIH0sXG4gICAgICBbdGhpcy5zaWduT3V0VXJsUGF0aF06IHtcbiAgICAgICAgb3JpZ2luLFxuICAgICAgICBjb21wcmVzczogdHJ1ZSxcbiAgICAgICAgb3JpZ2luUmVxdWVzdFBvbGljeTogYXdzX2Nsb3VkZnJvbnQuT3JpZ2luUmVxdWVzdFBvbGljeS5BTExfVklFV0VSLFxuICAgICAgICB2aWV3ZXJQcm90b2NvbFBvbGljeTogYXdzX2Nsb3VkZnJvbnQuVmlld2VyUHJvdG9jb2xQb2xpY3kuUkVESVJFQ1RfVE9fSFRUUFMsXG4gICAgICAgIGVkZ2VMYW1iZGFzOiBbdGhpcy5hdXRoRmxvdy5zaWduT3V0XSxcbiAgICAgICAgLi4ub3B0aW9ucyxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxuXG4gIHByaXZhdGUgZ2VuZXJhdGVOb25jZVNpZ25pbmdTZWNyZXQoKTogc3RyaW5nIHtcbiAgICBjb25zdCB7IHNlY3JldCB9ID0gbmV3IFNlY3JldEdlbmVyYXRvcih0aGlzLCAnU2VjcmV0R2VuZXJhdG9yJyk7XG4gICAgcmV0dXJuIHNlY3JldDtcbiAgfVxuXG4gIHByaXZhdGUgcmV0cmlldmVDb2duaXRvQXV0aERvbWFpbigpOiBzdHJpbmcge1xuICAgIGNvbnN0IHVzZXJQb29sRG9tYWluID0gbmV3IFVzZXJQb29sRG9tYWluKHRoaXMsICdVc2VyUG9vbERvbWFpbicsIHtcbiAgICAgIHVzZXJQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgIH0pO1xuXG4gICAgcmV0dXJuIHVzZXJQb29sRG9tYWluLmNvZ25pdG9BdXRoRG9tYWluO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSVNwYUF1dGhvcml6YXRpb24gZXh0ZW5kcyBJQXV0aG9yaXphdGlvbiB7XG4gIHJlYWRvbmx5IG1vZGU6IE1vZGUuU1BBO1xufVxuXG5leHBvcnQgdHlwZSBTcGFBdXRob3JpemF0aW9uUHJvcHMgPSBBdXRob3JpemF0aW9uUHJvcHM7XG5cbmV4cG9ydCBjbGFzcyBTcGFBdXRob3JpemF0aW9uIGV4dGVuZHMgQXV0aG9yaXphdGlvbiBpbXBsZW1lbnRzIElTcGFBdXRob3JpemF0aW9uIHtcbiAgcHVibGljIHJlYWRvbmx5IG1vZGUgPSBNb2RlLlNQQTtcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogU3BhQXV0aG9yaXphdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlVXNlclBvb2xDbGllbnQoKTogYXdzX2NvZ25pdG8uSVVzZXJQb29sQ2xpZW50IHtcbiAgICByZXR1cm4gdGhpcy51c2VyUG9vbC5hZGRDbGllbnQoJ1VzZXJQb29sQ2xpZW50Jywge1xuICAgICAgZ2VuZXJhdGVTZWNyZXQ6IGZhbHNlLFxuICAgICAgb0F1dGg6IHtcbiAgICAgICAgZmxvd3M6IHtcbiAgICAgICAgICBhdXRob3JpemF0aW9uQ29kZUdyYW50OiB0cnVlLFxuICAgICAgICB9LFxuICAgICAgICBzY29wZXM6IHRoaXMub2F1dGhTY29wZXMsXG4gICAgICB9LFxuICAgICAgc3VwcG9ydGVkSWRlbnRpdHlQcm92aWRlcnM6IHRoaXMuaWRlbnRpdHlQcm92aWRlcnMsXG4gICAgICBwcmV2ZW50VXNlckV4aXN0ZW5jZUVycm9yczogdHJ1ZSxcbiAgICB9KTtcbiAgfVxuXG4gIHByb3RlY3RlZCBjcmVhdGVBdXRoRmxvdyhsb2dMZXZlbDogTG9nTGV2ZWwpOiBBdXRoRmxvdyB7XG4gICAgcmV0dXJuIG5ldyBBdXRoRmxvdyh0aGlzLCAnQXV0aEZsb3cnLCB7XG4gICAgICBsb2dMZXZlbCxcbiAgICAgIHVzZXJQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgICAgdXNlclBvb2xDbGllbnQ6IHRoaXMudXNlclBvb2xDbGllbnQsXG4gICAgICBvYXV0aFNjb3BlczogdGhpcy5vYXV0aFNjb3BlcyxcbiAgICAgIHJlZGlyZWN0UGF0aHM6IHRoaXMucmVkaXJlY3RQYXRocyxcbiAgICAgIG5vbmNlU2lnbmluZ1NlY3JldDogdGhpcy5ub25jZVNpZ25pbmdTZWNyZXQsXG4gICAgICBjb2duaXRvQXV0aERvbWFpbjogdGhpcy5jb2duaXRvQXV0aERvbWFpbixcbiAgICAgIGNvb2tpZVNldHRpbmdzOiB0aGlzLmNvb2tpZVNldHRpbmdzID8/IHtcbiAgICAgICAgaWRUb2tlbjogJ1BhdGg9LzsgU2VjdXJlOyBTYW1lU2l0ZT1MYXgnLFxuICAgICAgICBhY2Nlc3NUb2tlbjogJ1BhdGg9LzsgU2VjdXJlOyBTYW1lU2l0ZT1MYXgnLFxuICAgICAgICByZWZyZXNoVG9rZW46ICdQYXRoPS87IFNlY3VyZTsgU2FtZVNpdGU9TGF4JyxcbiAgICAgICAgbm9uY2U6ICdQYXRoPS87IFNlY3VyZTsgSHR0cE9ubHk7IFNhbWVTaXRlPUxheCcsXG4gICAgICB9LFxuICAgIH0pO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgSVN0YXRpY1NpdGVBdXRob3JpemF0aW9uIGV4dGVuZHMgSUF1dGhvcml6YXRpb24ge1xuICByZWFkb25seSBtb2RlOiBNb2RlLlNUQVRJQ19TSVRFO1xufVxuXG5leHBvcnQgdHlwZSBTdGF0aWNTaXRlQXV0aG9yaXphdGlvblByb3BzID0gQXV0aG9yaXphdGlvblByb3BzO1xuXG5leHBvcnQgY2xhc3MgU3RhdGljU2l0ZUF1dGhvcml6YXRpb24gZXh0ZW5kcyBBdXRob3JpemF0aW9uIGltcGxlbWVudHMgSVN0YXRpY1NpdGVBdXRob3JpemF0aW9uIHtcbiAgcHVibGljIHJlYWRvbmx5IG1vZGUgPSBNb2RlLlNUQVRJQ19TSVRFO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBTdGF0aWNTaXRlQXV0aG9yaXphdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCBwcm9wcyk7XG4gIH1cblxuICBwcm90ZWN0ZWQgY3JlYXRlVXNlclBvb2xDbGllbnQoKTogYXdzX2NvZ25pdG8uSVVzZXJQb29sQ2xpZW50IHtcbiAgICByZXR1cm4gdGhpcy51c2VyUG9vbC5hZGRDbGllbnQoJ1VzZXJQb29sQ2xpZW50Jywge1xuICAgICAgZ2VuZXJhdGVTZWNyZXQ6IHRydWUsXG4gICAgICBvQXV0aDoge1xuICAgICAgICBmbG93czoge1xuICAgICAgICAgIGF1dGhvcml6YXRpb25Db2RlR3JhbnQ6IHRydWUsXG4gICAgICAgIH0sXG4gICAgICAgIHNjb3BlczogdGhpcy5vYXV0aFNjb3BlcyxcbiAgICAgIH0sXG4gICAgICBzdXBwb3J0ZWRJZGVudGl0eVByb3ZpZGVyczogdGhpcy5pZGVudGl0eVByb3ZpZGVycyxcbiAgICAgIHByZXZlbnRVc2VyRXhpc3RlbmNlRXJyb3JzOiB0cnVlLFxuICAgIH0pO1xuICB9XG5cbiAgcHJvdGVjdGVkIGNyZWF0ZUF1dGhGbG93KGxvZ0xldmVsOiBMb2dMZXZlbCk6IEF1dGhGbG93IHtcbiAgICBjb25zdCBjbGllbnRTZWNyZXQgPSB0aGlzLnJldHJpZXZlVXNlclBvb2xDbGllbnRTZWNyZXQoKTtcblxuICAgIHJldHVybiBuZXcgQXV0aEZsb3codGhpcywgJ0F1dGhGbG93Jywge1xuICAgICAgbG9nTGV2ZWwsXG4gICAgICB1c2VyUG9vbDogdGhpcy51c2VyUG9vbCxcbiAgICAgIHVzZXJQb29sQ2xpZW50OiB0aGlzLnVzZXJQb29sQ2xpZW50LFxuICAgICAgb2F1dGhTY29wZXM6IHRoaXMub2F1dGhTY29wZXMsXG4gICAgICByZWRpcmVjdFBhdGhzOiB0aGlzLnJlZGlyZWN0UGF0aHMsXG4gICAgICBub25jZVNpZ25pbmdTZWNyZXQ6IHRoaXMubm9uY2VTaWduaW5nU2VjcmV0LFxuICAgICAgY29nbml0b0F1dGhEb21haW46IHRoaXMuY29nbml0b0F1dGhEb21haW4sXG4gICAgICBjbGllbnRTZWNyZXQsXG4gICAgICBjb29raWVTZXR0aW5nczogdGhpcy5jb29raWVTZXR0aW5ncyA/PyB7XG4gICAgICAgIGlkVG9rZW46ICdQYXRoPS87IFNlY3VyZTsgSHR0cE9ubHk7IFNhbWVTaXRlPUxheCcsXG4gICAgICAgIGFjY2Vzc1Rva2VuOiAnUGF0aD0vOyBTZWN1cmU7IEh0dHBPbmx5OyBTYW1lU2l0ZT1MYXgnLFxuICAgICAgICByZWZyZXNoVG9rZW46ICdQYXRoPS87IFNlY3VyZTsgSHR0cE9ubHk7IFNhbWVTaXRlPUxheCcsXG4gICAgICAgIG5vbmNlOiAnUGF0aD0vOyBTZWN1cmU7IEh0dHBPbmx5OyBTYW1lU2l0ZT1MYXgnLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxuXG4gIHByaXZhdGUgcmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldCgpOiBzdHJpbmcge1xuICAgIGNvbnN0IHsgY2xpZW50U2VjcmV0IH0gPSBuZXcgUmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldCh0aGlzLCAnUmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldCcsIHtcbiAgICAgIHVzZXJQb29sOiB0aGlzLnVzZXJQb29sLFxuICAgICAgdXNlclBvb2xDbGllbnQ6IHRoaXMudXNlclBvb2xDbGllbnQsXG4gICAgfSk7XG5cbiAgICByZXR1cm4gY2xpZW50U2VjcmV0O1xuICB9XG59XG5cbmV4cG9ydCBlbnVtIE1vZGUge1xuICBTUEEgPSAnU1BBJyxcbiAgU1RBVElDX1NJVEUgPSAnU1RBVElDX1NJVEUnLFxufVxuIl19