"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RetrieveUserPoolClientSecret = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class RetrieveUserPoolClientSecret extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const clientSecret = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'describeUserPoolClient',
                parameters: {
                    UserPoolId: props.userPool.userPoolId,
                    ClientId: props.userPoolClient.userPoolClientId,
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(`${props.userPool.userPoolId}-${props.userPoolClient.userPoolClientId}-retrieved-client-secret`),
            },
            policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.userPool.userPoolArn],
            }),
        });
        this.clientSecret = clientSecret.getResponseField('UserPoolClient.ClientSecret');
    }
}
exports.RetrieveUserPoolClientSecret = RetrieveUserPoolClientSecret;
_a = JSII_RTTI_SYMBOL_1;
RetrieveUserPoolClientSecret[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.RetrieveUserPoolClientSecret", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicmV0cmlldmUtdXNlci1wb29sLWNsaWVudC1zZWNyZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvcmV0cmlldmUtdXNlci1wb29sLWNsaWVudC1zZWNyZXQudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw2Q0FBNEQ7QUFDNUQsMkNBQXVDO0FBT3ZDLE1BQWEsNEJBQTZCLFNBQVEsc0JBQVM7SUFHekQsWUFBWSxLQUFnQixFQUFFLEVBQVUsRUFBRSxLQUF3QztRQUNoRixLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sWUFBWSxHQUFHLElBQUksOEJBQWdCLENBQUMsaUJBQWlCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUM1RSxRQUFRLEVBQUU7Z0JBQ1IsT0FBTyxFQUFFLGdDQUFnQztnQkFDekMsTUFBTSxFQUFFLHdCQUF3QjtnQkFDaEMsVUFBVSxFQUFFO29CQUNWLFVBQVUsRUFBRSxLQUFLLENBQUMsUUFBUSxDQUFDLFVBQVU7b0JBQ3JDLFFBQVEsRUFBRSxLQUFLLENBQUMsY0FBYyxDQUFDLGdCQUFnQjtpQkFDaEQ7Z0JBQ0Qsa0JBQWtCLEVBQUUsOEJBQWdCLENBQUMsa0JBQWtCLENBQUMsRUFBRSxDQUN4RCxHQUFHLEtBQUssQ0FBQyxRQUFRLENBQUMsVUFBVSxJQUFJLEtBQUssQ0FBQyxjQUFjLENBQUMsZ0JBQWdCLDBCQUEwQixDQUNoRzthQUNGO1lBQ0QsTUFBTSxFQUFFLDhCQUFnQixDQUFDLHVCQUF1QixDQUFDLFlBQVksQ0FBQztnQkFDNUQsU0FBUyxFQUFFLENBQUMsS0FBSyxDQUFDLFFBQVEsQ0FBQyxXQUFXLENBQUM7YUFDeEMsQ0FBQztTQUNILENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDLGdCQUFnQixDQUFDLDZCQUE2QixDQUFDLENBQUM7SUFDbkYsQ0FBQzs7QUF4Qkgsb0VBeUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzX2NvZ25pdG8sIGN1c3RvbV9yZXNvdXJjZXMgfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuZXhwb3J0IGludGVyZmFjZSBSZXRyaWV2ZVVzZXJQb29sQ2xpZW50U2VjcmV0UHJvcHMge1xuICByZWFkb25seSB1c2VyUG9vbENsaWVudDogYXdzX2NvZ25pdG8uSVVzZXJQb29sQ2xpZW50O1xuICByZWFkb25seSB1c2VyUG9vbDogYXdzX2NvZ25pdG8uSVVzZXJQb29sO1xufVxuXG5leHBvcnQgY2xhc3MgUmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldCBleHRlbmRzIENvbnN0cnVjdCB7XG4gIHB1YmxpYyBjbGllbnRTZWNyZXQ6IHN0cmluZztcblxuICBjb25zdHJ1Y3RvcihzY29wZTogQ29uc3RydWN0LCBpZDogc3RyaW5nLCBwcm9wczogUmV0cmlldmVVc2VyUG9vbENsaWVudFNlY3JldFByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcblxuICAgIGNvbnN0IGNsaWVudFNlY3JldCA9IG5ldyBjdXN0b21fcmVzb3VyY2VzLkF3c0N1c3RvbVJlc291cmNlKHRoaXMsICdSZXNvdXJjZScsIHtcbiAgICAgIG9uVXBkYXRlOiB7XG4gICAgICAgIHNlcnZpY2U6ICdDb2duaXRvSWRlbnRpdHlTZXJ2aWNlUHJvdmlkZXInLFxuICAgICAgICBhY3Rpb246ICdkZXNjcmliZVVzZXJQb29sQ2xpZW50JyxcbiAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgIFVzZXJQb29sSWQ6IHByb3BzLnVzZXJQb29sLnVzZXJQb29sSWQsXG4gICAgICAgICAgQ2xpZW50SWQ6IHByb3BzLnVzZXJQb29sQ2xpZW50LnVzZXJQb29sQ2xpZW50SWQsXG4gICAgICAgIH0sXG4gICAgICAgIHBoeXNpY2FsUmVzb3VyY2VJZDogY3VzdG9tX3Jlc291cmNlcy5QaHlzaWNhbFJlc291cmNlSWQub2YoXG4gICAgICAgICAgYCR7cHJvcHMudXNlclBvb2wudXNlclBvb2xJZH0tJHtwcm9wcy51c2VyUG9vbENsaWVudC51c2VyUG9vbENsaWVudElkfS1yZXRyaWV2ZWQtY2xpZW50LXNlY3JldGAsXG4gICAgICAgICksXG4gICAgICB9LFxuICAgICAgcG9saWN5OiBjdXN0b21fcmVzb3VyY2VzLkF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgIHJlc291cmNlczogW3Byb3BzLnVzZXJQb29sLnVzZXJQb29sQXJuXSxcbiAgICAgIH0pLFxuICAgIH0pO1xuXG4gICAgdGhpcy5jbGllbnRTZWNyZXQgPSBjbGllbnRTZWNyZXQuZ2V0UmVzcG9uc2VGaWVsZCgnVXNlclBvb2xDbGllbnQuQ2xpZW50U2VjcmV0Jyk7XG4gIH1cbn1cbiJdfQ==