"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Mode = exports.StaticSiteAuthorization = exports.SpaAuthorization = exports.Authorization = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk_lambda_at_edge_pattern_1 = require("@cloudcomponents/cdk-lambda-at-edge-pattern");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const auth_flow_1 = require("./auth-flow");
const retrieve_user_pool_client_secret_1 = require("./retrieve-user-pool-client-secret");
const secret_generator_1 = require("./secret-generator");
const user_pool_client_redirects_1 = require("./user-pool-client-redirects");
const user_pool_domain_1 = require("./user-pool-domain");
class Authorization extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        this.userPool = props.userPool;
        this.redirectPaths = props.redirectPaths ?? {
            signIn: '/parseauth',
            authRefresh: '/refreshauth',
            signOut: '/',
        };
        this.signOutUrlPath = props.signOutUrl ?? '/signout';
        this.responseHeaderPolicy = new aws_cdk_lib_1.aws_cloudfront.ResponseHeadersPolicy(this, 'ResponseHeadersPolicy', {
            securityHeadersBehavior: props.securityHeadersBehavior ?? {
                contentSecurityPolicy: {
                    contentSecurityPolicy: "default-src 'none'; img-src 'self'; script-src 'self'; style-src 'self' 'unsafe-inline'; object-src 'none'; connect-src 'self'",
                    override: true,
                },
                contentTypeOptions: { override: true },
                frameOptions: { frameOption: aws_cdk_lib_1.aws_cloudfront.HeadersFrameOption.DENY, override: true },
                referrerPolicy: { referrerPolicy: aws_cdk_lib_1.aws_cloudfront.HeadersReferrerPolicy.SAME_ORIGIN, override: true },
                strictTransportSecurity: { accessControlMaxAge: aws_cdk_lib_1.Duration.seconds(31536000), includeSubdomains: true, preload: true, override: true },
                xssProtection: { protection: true, modeBlock: true, override: true },
            },
            customHeadersBehavior: {
                customHeaders: props.customHeaders ?? [
                    {
                        header: 'Cache-Control',
                        value: 'no-cache',
                        override: true,
                    },
                ],
            },
        });
        this.oauthScopes = props.oauthScopes ?? [
            aws_cdk_lib_1.aws_cognito.OAuthScope.PHONE,
            aws_cdk_lib_1.aws_cognito.OAuthScope.EMAIL,
            aws_cdk_lib_1.aws_cognito.OAuthScope.PROFILE,
            aws_cdk_lib_1.aws_cognito.OAuthScope.OPENID,
            aws_cdk_lib_1.aws_cognito.OAuthScope.COGNITO_ADMIN,
        ];
        this.cookieSettings = props.cookieSettings;
        this.identityProviders = props.identityProviders ?? [aws_cdk_lib_1.aws_cognito.UserPoolClientIdentityProvider.COGNITO];
        this.userPoolClient = this.createUserPoolClient();
        this.nonceSigningSecret = this.generateNonceSigningSecret();
        this.cognitoAuthDomain = this.retrieveCognitoAuthDomain();
        this.authFlow = this.createAuthFlow(props.logLevel ?? cdk_lambda_at_edge_pattern_1.LogLevel.WARN);
    }
    updateUserPoolClientCallbacks(redirects) {
        const { callbackUrls, logoutUrls } = redirects;
        new user_pool_client_redirects_1.UserPoolClientRedirects(this, 'UserPoolClientRedirects', {
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            callbackUrls,
            logoutUrls,
            identityProviders: this.identityProviders,
        });
    }
    createDefaultBehavior(origin, options) {
        return {
            origin,
            compress: true,
            originRequestPolicy: aws_cdk_lib_1.aws_cloudfront.OriginRequestPolicy.ALL_VIEWER,
            viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
            edgeLambdas: [this.authFlow.checkAuth],
            responseHeadersPolicy: this.responseHeaderPolicy,
            ...options,
        };
    }
    createAdditionalBehaviors(origin, options) {
        return {
            [this.redirectPaths.signIn]: {
                origin,
                compress: true,
                originRequestPolicy: aws_cdk_lib_1.aws_cloudfront.OriginRequestPolicy.ALL_VIEWER,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.parseAuth],
                ...options,
            },
            [this.redirectPaths.authRefresh]: {
                origin,
                compress: true,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.refreshAuth],
                ...options,
            },
            [this.signOutUrlPath]: {
                origin,
                compress: true,
                originRequestPolicy: aws_cdk_lib_1.aws_cloudfront.OriginRequestPolicy.ALL_VIEWER,
                viewerProtocolPolicy: aws_cdk_lib_1.aws_cloudfront.ViewerProtocolPolicy.REDIRECT_TO_HTTPS,
                edgeLambdas: [this.authFlow.signOut],
                ...options,
            },
        };
    }
    generateNonceSigningSecret() {
        const { secret } = new secret_generator_1.SecretGenerator(this, 'SecretGenerator');
        return secret;
    }
    retrieveCognitoAuthDomain() {
        const userPoolDomain = new user_pool_domain_1.UserPoolDomain(this, 'UserPoolDomain', {
            userPool: this.userPool,
        });
        return userPoolDomain.cognitoAuthDomain;
    }
}
exports.Authorization = Authorization;
_a = JSII_RTTI_SYMBOL_1;
Authorization[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.Authorization", version: "2.2.0" };
class SpaAuthorization extends Authorization {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.mode = Mode.SPA;
    }
    createUserPoolClient() {
        return this.userPool.addClient('UserPoolClient', {
            generateSecret: false,
            oAuth: {
                flows: {
                    authorizationCodeGrant: true,
                },
                scopes: this.oauthScopes,
            },
            supportedIdentityProviders: this.identityProviders,
            preventUserExistenceErrors: true,
        });
    }
    createAuthFlow(logLevel) {
        return new auth_flow_1.AuthFlow(this, 'AuthFlow', {
            logLevel,
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            redirectPaths: this.redirectPaths,
            nonceSigningSecret: this.nonceSigningSecret,
            cognitoAuthDomain: this.cognitoAuthDomain,
            cookieSettings: this.cookieSettings ?? {
                idToken: 'Path=/; Secure; SameSite=Lax',
                accessToken: 'Path=/; Secure; SameSite=Lax',
                refreshToken: 'Path=/; Secure; SameSite=Lax',
                nonce: 'Path=/; Secure; HttpOnly; SameSite=Lax',
            },
        });
    }
}
exports.SpaAuthorization = SpaAuthorization;
_b = JSII_RTTI_SYMBOL_1;
SpaAuthorization[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaAuthorization", version: "2.2.0" };
class StaticSiteAuthorization extends Authorization {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.mode = Mode.STATIC_SITE;
    }
    createUserPoolClient() {
        return this.userPool.addClient('UserPoolClient', {
            generateSecret: true,
            oAuth: {
                flows: {
                    authorizationCodeGrant: true,
                },
                scopes: this.oauthScopes,
            },
            supportedIdentityProviders: this.identityProviders,
            preventUserExistenceErrors: true,
        });
    }
    createAuthFlow(logLevel) {
        const clientSecret = this.retrieveUserPoolClientSecret();
        return new auth_flow_1.AuthFlow(this, 'AuthFlow', {
            logLevel,
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
            oauthScopes: this.oauthScopes,
            redirectPaths: this.redirectPaths,
            nonceSigningSecret: this.nonceSigningSecret,
            cognitoAuthDomain: this.cognitoAuthDomain,
            clientSecret,
            cookieSettings: this.cookieSettings ?? {
                idToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                accessToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                refreshToken: 'Path=/; Secure; HttpOnly; SameSite=Lax',
                nonce: 'Path=/; Secure; HttpOnly; SameSite=Lax',
            },
        });
    }
    retrieveUserPoolClientSecret() {
        const { clientSecret } = new retrieve_user_pool_client_secret_1.RetrieveUserPoolClientSecret(this, 'RetrieveUserPoolClientSecret', {
            userPool: this.userPool,
            userPoolClient: this.userPoolClient,
        });
        return clientSecret;
    }
}
exports.StaticSiteAuthorization = StaticSiteAuthorization;
_c = JSII_RTTI_SYMBOL_1;
StaticSiteAuthorization[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteAuthorization", version: "2.2.0" };
var Mode;
(function (Mode) {
    Mode["SPA"] = "SPA";
    Mode["STATIC_SITE"] = "STATIC_SITE";
})(Mode = exports.Mode || (exports.Mode = {}));
//# sourceMappingURL=data:application/json;base64,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