"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class BaseDistribution extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const origin = props.origin ?? this.defaultOrigin(removalPolicy);
        const distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            enabled: props.enabled ?? true,
            enableIpv6: props.enableIpv6 ?? true,
            comment: props.comment,
            enableLogging: props.enableLogging,
            logBucket: props.logBucket,
            logIncludesCookies: props.logIncludesCookies,
            logFilePrefix: props.logFilePrefix,
            priceClass: props.priceClass ?? aws_cdk_lib_1.aws_cloudfront.PriceClass.PRICE_CLASS_100,
            geoRestriction: props.geoRestriction,
            httpVersion: props.httpVersion ?? aws_cdk_lib_1.aws_cloudfront.HttpVersion.HTTP2,
            webAclId: props.webAclId,
            minimumProtocolVersion: props.minimumProtocolVersion,
            errorResponses: props.errorResponses,
            domainNames: props.domainNames,
            certificate: props.certificate,
            defaultBehavior: this.renderDefaultBehaviour(origin, props.authorization),
            additionalBehaviors: this.renderAdditionalBehaviors(origin, props.authorization),
            defaultRootObject: props.defaultRootObject ?? 'index.html',
        });
        this.distribution = distribution;
        const callbackUrls = props.domainNames?.map((name) => `https://${name}${props.authorization.redirectPaths.signIn}`) ?? [];
        const logoutUrls = props.domainNames?.map((name) => `https://${name}${props.authorization.redirectPaths.signOut}`) ?? [];
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`, ...callbackUrls],
            logoutUrls: [`https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`, ...logoutUrls],
        });
        this.domainName = distribution.domainName;
        this.distributionDomainName = distribution.distributionDomainName;
        this.distributionId = distribution.distributionId;
        this.stack = aws_cdk_lib_1.Stack.of(this);
        this.env = {
            account: this.stack.account,
            region: this.stack.region,
        };
    }
    grant(identity, ...actions) {
        return this.distribution.grant(identity, ...actions);
    }
    grantCreateInvalidation(identity) {
        return this.distribution.grantCreateInvalidation(identity);
    }
    applyRemovalPolicy(policy) {
        const child = this.node.defaultChild;
        if (!child || !aws_cdk_lib_1.CfnResource.isCfnResource(child)) {
            throw new Error('Cannot apply RemovalPolicy: no child or not a CfnResource. Apply the removal policy on the CfnResource directly.');
        }
        child.applyRemovalPolicy(policy);
    }
    renderDefaultBehaviour(origin, authorization) {
        return authorization.createDefaultBehavior(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cdk_lib_1.aws_cloudfront.CachePolicy.CACHING_DISABLED,
        });
    }
    renderAdditionalBehaviors(origin, authorization) {
        return authorization.createAdditionalBehaviors(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cdk_lib_1.aws_cloudfront.CachePolicy.CACHING_DISABLED,
        });
    }
    defaultOrigin(removalPolicy) {
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            autoDeleteObjects: removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY,
            removalPolicy,
        });
        return new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
_a = JSII_RTTI_SYMBOL_1;
BaseDistribution[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.BaseDistribution", version: "2.2.0" };
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
_b = JSII_RTTI_SYMBOL_1;
StaticSiteDistribution[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteDistribution", version: "2.2.0" };
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: props.ttl ?? aws_cdk_lib_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
_c = JSII_RTTI_SYMBOL_1;
SpaDistribution[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaDistribution", version: "2.2.0" };
//# sourceMappingURL=data:application/json;base64,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