import { LogLevel } from '@cloudcomponents/cdk-lambda-at-edge-pattern';
import { aws_cloudfront, aws_cognito } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { AuthFlow, RedirectPaths } from './auth-flow';
export interface UserPoolClientCallbackUrls {
    /**
     * A list of allowed redirect (callback) URLs for the identity providers.
     */
    readonly callbackUrls: string[];
    /**
     * A list of allowed logout URLs for the identity providers.
     */
    readonly logoutUrls: string[];
}
export interface IAuthorization {
    readonly redirectPaths: RedirectPaths;
    readonly signOutUrlPath: string;
    updateUserPoolClientCallbacks(redirects: UserPoolClientCallbackUrls): void;
    createDefaultBehavior(origin: aws_cloudfront.IOrigin, options?: aws_cloudfront.AddBehaviorOptions): aws_cloudfront.BehaviorOptions;
    createAdditionalBehaviors(origin: aws_cloudfront.IOrigin, options?: aws_cloudfront.AddBehaviorOptions): Record<string, aws_cloudfront.BehaviorOptions>;
}
export interface AuthorizationProps {
    readonly userPool: aws_cognito.IUserPool;
    readonly redirectPaths?: RedirectPaths;
    readonly signOutUrl?: string;
    readonly customHeaders?: aws_cloudfront.ResponseCustomHeader[];
    readonly securityHeadersBehavior?: aws_cloudfront.ResponseSecurityHeadersBehavior;
    readonly logLevel?: LogLevel;
    readonly oauthScopes?: aws_cognito.OAuthScope[];
    readonly cookieSettings?: Record<string, string>;
    readonly identityProviders?: aws_cognito.UserPoolClientIdentityProvider[];
}
export declare abstract class Authorization extends Construct {
    readonly redirectPaths: RedirectPaths;
    readonly signOutUrlPath: string;
    readonly authFlow: AuthFlow;
    readonly userPoolClient: aws_cognito.IUserPoolClient;
    protected readonly userPool: aws_cognito.IUserPool;
    protected readonly oauthScopes: aws_cognito.OAuthScope[];
    protected readonly cookieSettings: Record<string, string> | undefined;
    protected readonly nonceSigningSecret: string;
    protected readonly cognitoAuthDomain: string;
    protected readonly identityProviders: aws_cognito.UserPoolClientIdentityProvider[];
    protected readonly responseHeaderPolicy: aws_cloudfront.IResponseHeadersPolicy;
    constructor(scope: Construct, id: string, props: AuthorizationProps);
    protected abstract createUserPoolClient(): aws_cognito.IUserPoolClient;
    protected abstract createAuthFlow(logLevel: LogLevel): AuthFlow;
    updateUserPoolClientCallbacks(redirects: UserPoolClientCallbackUrls): void;
    createDefaultBehavior(origin: aws_cloudfront.IOrigin, options?: aws_cloudfront.AddBehaviorOptions): aws_cloudfront.BehaviorOptions;
    createAdditionalBehaviors(origin: aws_cloudfront.IOrigin, options?: aws_cloudfront.AddBehaviorOptions): Record<string, aws_cloudfront.BehaviorOptions>;
    private generateNonceSigningSecret;
    private retrieveCognitoAuthDomain;
}
export interface ISpaAuthorization extends IAuthorization {
    readonly mode: Mode.SPA;
}
export declare type SpaAuthorizationProps = AuthorizationProps;
export declare class SpaAuthorization extends Authorization implements ISpaAuthorization {
    readonly mode = Mode.SPA;
    constructor(scope: Construct, id: string, props: SpaAuthorizationProps);
    protected createUserPoolClient(): aws_cognito.IUserPoolClient;
    protected createAuthFlow(logLevel: LogLevel): AuthFlow;
}
export interface IStaticSiteAuthorization extends IAuthorization {
    readonly mode: Mode.STATIC_SITE;
}
export declare type StaticSiteAuthorizationProps = AuthorizationProps;
export declare class StaticSiteAuthorization extends Authorization implements IStaticSiteAuthorization {
    readonly mode = Mode.STATIC_SITE;
    constructor(scope: Construct, id: string, props: StaticSiteAuthorizationProps);
    protected createUserPoolClient(): aws_cognito.IUserPoolClient;
    protected createAuthFlow(logLevel: LogLevel): AuthFlow;
    private retrieveUserPoolClientSecret;
}
export declare enum Mode {
    SPA = "SPA",
    STATIC_SITE = "STATIC_SITE"
}
