"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SpaDistribution = exports.StaticSiteDistribution = exports.BaseDistribution = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class BaseDistribution extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const removalPolicy = props.removalPolicy ?? aws_cdk_lib_1.RemovalPolicy.DESTROY;
        const origin = props.origin ?? this.defaultOrigin(removalPolicy);
        const distribution = new aws_cdk_lib_1.aws_cloudfront.Distribution(this, 'Distribution', {
            enabled: props.enabled ?? true,
            enableIpv6: props.enableIpv6 ?? true,
            comment: props.comment,
            enableLogging: props.enableLogging,
            logBucket: props.logBucket,
            logIncludesCookies: props.logIncludesCookies,
            logFilePrefix: props.logFilePrefix,
            priceClass: props.priceClass ?? aws_cdk_lib_1.aws_cloudfront.PriceClass.PRICE_CLASS_100,
            geoRestriction: props.geoRestriction,
            httpVersion: props.httpVersion ?? aws_cdk_lib_1.aws_cloudfront.HttpVersion.HTTP2,
            webAclId: props.webAclId,
            minimumProtocolVersion: props.minimumProtocolVersion,
            errorResponses: props.errorResponses,
            domainNames: props.domainNames,
            certificate: props.certificate,
            defaultBehavior: this.renderDefaultBehaviour(origin, props.authorization),
            additionalBehaviors: this.renderAdditionalBehaviors(origin, props.authorization),
            defaultRootObject: props.defaultRootObject ?? 'index.html',
        });
        this.distribution = distribution;
        const callbackUrls = props.domainNames?.map((name) => `https://${name}${props.authorization.redirectPaths.signIn}`) ?? [];
        const logoutUrls = props.domainNames?.map((name) => `https://${name}${props.authorization.redirectPaths.signOut}`) ?? [];
        props.authorization.updateUserPoolClientCallbacks({
            callbackUrls: [
                `https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signIn}`,
                ...callbackUrls,
            ],
            logoutUrls: [
                `https://${distribution.distributionDomainName}${props.authorization.redirectPaths.signOut}`,
                ...logoutUrls,
            ],
        });
        this.domainName = distribution.domainName;
        this.distributionDomainName = distribution.distributionDomainName;
        this.distributionId = distribution.distributionId;
        this.stack = aws_cdk_lib_1.Stack.of(this);
        this.env = {
            account: this.stack.account,
            region: this.stack.region,
        };
    }
    grant(identity, ...actions) {
        return this.distribution.grant(identity, ...actions);
    }
    grantCreateInvalidation(identity) {
        return this.distribution.grantCreateInvalidation(identity);
    }
    applyRemovalPolicy(policy) {
        const child = this.node.defaultChild;
        if (!child || !aws_cdk_lib_1.CfnResource.isCfnResource(child)) {
            throw new Error('Cannot apply RemovalPolicy: no child or not a CfnResource. Apply the removal policy on the CfnResource directly.');
        }
        child.applyRemovalPolicy(policy);
    }
    renderDefaultBehaviour(origin, authorization) {
        return authorization.createDefaultBehavior(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cdk_lib_1.aws_cloudfront.CachePolicy.CACHING_DISABLED,
        });
    }
    renderAdditionalBehaviors(origin, authorization) {
        return authorization.createAdditionalBehaviors(origin, {
            originRequestPolicy: undefined,
            cachePolicy: aws_cdk_lib_1.aws_cloudfront.CachePolicy.CACHING_DISABLED,
        });
    }
    defaultOrigin(removalPolicy) {
        const bucket = new aws_cdk_lib_1.aws_s3.Bucket(this, 'Bucket', {
            autoDeleteObjects: removalPolicy === aws_cdk_lib_1.RemovalPolicy.DESTROY,
            removalPolicy,
        });
        return new aws_cdk_lib_1.aws_cloudfront_origins.S3Origin(bucket);
    }
}
exports.BaseDistribution = BaseDistribution;
_a = JSII_RTTI_SYMBOL_1;
BaseDistribution[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.BaseDistribution", version: "2.4.0" };
class StaticSiteDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, props);
    }
}
exports.StaticSiteDistribution = StaticSiteDistribution;
_b = JSII_RTTI_SYMBOL_1;
StaticSiteDistribution[_b] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.StaticSiteDistribution", version: "2.4.0" };
class SpaDistribution extends BaseDistribution {
    constructor(scope, id, props) {
        super(scope, id, {
            ...props,
            errorResponses: [
                {
                    httpStatus: 404,
                    responseHttpStatus: 200,
                    ttl: props.ttl ?? aws_cdk_lib_1.Duration.seconds(300),
                    responsePagePath: '/index.html',
                },
            ],
        });
    }
}
exports.SpaDistribution = SpaDistribution;
_c = JSII_RTTI_SYMBOL_1;
SpaDistribution[_c] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SpaDistribution", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGlzdHJpYnV0aW9ucy5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9kaXN0cmlidXRpb25zLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBVXFCO0FBRXJCLDJDQUFtRDtBQXFKbkQsTUFBYSxnQkFBaUIsU0FBUSxzQkFBUztJQVM3QyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTRCO1FBQ3BFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxhQUFhLEdBQUcsS0FBSyxDQUFDLGFBQWEsSUFBSSwyQkFBYSxDQUFDLE9BQU8sQ0FBQztRQUNuRSxNQUFNLE1BQU0sR0FBRyxLQUFLLENBQUMsTUFBTSxJQUFJLElBQUksQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLENBQUM7UUFFakUsTUFBTSxZQUFZLEdBQUcsSUFBSSw0QkFBYyxDQUFDLFlBQVksQ0FBQyxJQUFJLEVBQUUsY0FBYyxFQUFFO1lBQ3pFLE9BQU8sRUFBRSxLQUFLLENBQUMsT0FBTyxJQUFJLElBQUk7WUFDOUIsVUFBVSxFQUFFLEtBQUssQ0FBQyxVQUFVLElBQUksSUFBSTtZQUNwQyxPQUFPLEVBQUUsS0FBSyxDQUFDLE9BQU87WUFDdEIsYUFBYSxFQUFFLEtBQUssQ0FBQyxhQUFhO1lBQ2xDLFNBQVMsRUFBRSxLQUFLLENBQUMsU0FBUztZQUMxQixrQkFBa0IsRUFBRSxLQUFLLENBQUMsa0JBQWtCO1lBQzVDLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxVQUFVLEVBQUUsS0FBSyxDQUFDLFVBQVUsSUFBSSw0QkFBYyxDQUFDLFVBQVUsQ0FBQyxlQUFlO1lBQ3pFLGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVcsSUFBSSw0QkFBYyxDQUFDLFdBQVcsQ0FBQyxLQUFLO1lBQ2xFLFFBQVEsRUFBRSxLQUFLLENBQUMsUUFBUTtZQUN4QixzQkFBc0IsRUFBRSxLQUFLLENBQUMsc0JBQXNCO1lBQ3BELGNBQWMsRUFBRSxLQUFLLENBQUMsY0FBYztZQUNwQyxXQUFXLEVBQUUsS0FBSyxDQUFDLFdBQVc7WUFDOUIsV0FBVyxFQUFFLEtBQUssQ0FBQyxXQUFXO1lBQzlCLGVBQWUsRUFBRSxJQUFJLENBQUMsc0JBQXNCLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxhQUFhLENBQUM7WUFDekUsbUJBQW1CLEVBQUUsSUFBSSxDQUFDLHlCQUF5QixDQUFDLE1BQU0sRUFBRSxLQUFLLENBQUMsYUFBYSxDQUFDO1lBQ2hGLGlCQUFpQixFQUFFLEtBQUssQ0FBQyxpQkFBaUIsSUFBSSxZQUFZO1NBQzNELENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUcsWUFBWSxDQUFDO1FBRWpDLE1BQU0sWUFBWSxHQUNoQixLQUFLLENBQUMsV0FBVyxFQUFFLEdBQUcsQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsV0FBVyxJQUFJLEdBQUcsS0FBSyxDQUFDLGFBQWEsQ0FBQyxhQUFhLENBQUMsTUFBTSxFQUFFLENBQUMsSUFBSSxFQUFFLENBQUM7UUFDdkcsTUFBTSxVQUFVLEdBQ2QsS0FBSyxDQUFDLFdBQVcsRUFBRSxHQUFHLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRSxDQUFDLFdBQVcsSUFBSSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRSxDQUFDLElBQUksRUFBRSxDQUFDO1FBRXhHLEtBQUssQ0FBQyxhQUFhLENBQUMsNkJBQTZCLENBQUM7WUFDaEQsWUFBWSxFQUFFO2dCQUNaLFdBQVcsWUFBWSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLE1BQU0sRUFBRTtnQkFDM0YsR0FBRyxZQUFZO2FBQ2hCO1lBQ0QsVUFBVSxFQUFFO2dCQUNWLFdBQVcsWUFBWSxDQUFDLHNCQUFzQixHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUMsYUFBYSxDQUFDLE9BQU8sRUFBRTtnQkFDNUYsR0FBRyxVQUFVO2FBQ2Q7U0FDRixDQUFDLENBQUM7UUFFSCxJQUFJLENBQUMsVUFBVSxHQUFHLFlBQVksQ0FBQyxVQUFVLENBQUM7UUFDMUMsSUFBSSxDQUFDLHNCQUFzQixHQUFHLFlBQVksQ0FBQyxzQkFBc0IsQ0FBQztRQUNsRSxJQUFJLENBQUMsY0FBYyxHQUFHLFlBQVksQ0FBQyxjQUFjLENBQUM7UUFFbEQsSUFBSSxDQUFDLEtBQUssR0FBRyxtQkFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUM1QixJQUFJLENBQUMsR0FBRyxHQUFHO1lBQ1QsT0FBTyxFQUFFLElBQUksQ0FBQyxLQUFLLENBQUMsT0FBTztZQUMzQixNQUFNLEVBQUUsSUFBSSxDQUFDLEtBQUssQ0FBQyxNQUFNO1NBQzFCLENBQUM7SUFDSixDQUFDO0lBRU0sS0FBSyxDQUFDLFFBQW9CLEVBQUUsR0FBRyxPQUFpQjtRQUNyRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsS0FBSyxDQUFDLFFBQVEsRUFBRSxHQUFHLE9BQU8sQ0FBQyxDQUFDO0lBQ3ZELENBQUM7SUFFTSx1QkFBdUIsQ0FBQyxRQUFvQjtRQUNqRCxPQUFPLElBQUksQ0FBQyxZQUFZLENBQUMsdUJBQXVCLENBQUMsUUFBUSxDQUFDLENBQUM7SUFDN0QsQ0FBQztJQUVNLGtCQUFrQixDQUFDLE1BQXFCO1FBQzdDLE1BQU0sS0FBSyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsWUFBMEIsQ0FBQztRQUNuRCxJQUFJLENBQUMsS0FBSyxJQUFJLENBQUMseUJBQVcsQ0FBQyxhQUFhLENBQUMsS0FBSyxDQUFDLEVBQUU7WUFDL0MsTUFBTSxJQUFJLEtBQUssQ0FDYixrSEFBa0gsQ0FDbkgsQ0FBQztTQUNIO1FBQ0QsS0FBSyxDQUFDLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQ25DLENBQUM7SUFFUyxzQkFBc0IsQ0FDOUIsTUFBOEIsRUFDOUIsYUFBNkI7UUFFN0IsT0FBTyxhQUFhLENBQUMscUJBQXFCLENBQUMsTUFBTSxFQUFFO1lBQ2pELG1CQUFtQixFQUFFLFNBQVM7WUFDOUIsV0FBVyxFQUFFLDRCQUFjLENBQUMsV0FBVyxDQUFDLGdCQUFnQjtTQUN6RCxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRVMseUJBQXlCLENBQ2pDLE1BQThCLEVBQzlCLGFBQTZCO1FBRTdCLE9BQU8sYUFBYSxDQUFDLHlCQUF5QixDQUFDLE1BQU0sRUFBRTtZQUNyRCxtQkFBbUIsRUFBRSxTQUFTO1lBQzlCLFdBQVcsRUFBRSw0QkFBYyxDQUFDLFdBQVcsQ0FBQyxnQkFBZ0I7U0FDekQsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztJQUVPLGFBQWEsQ0FBQyxhQUE0QjtRQUNoRCxNQUFNLE1BQU0sR0FBRyxJQUFJLG9CQUFNLENBQUMsTUFBTSxDQUFDLElBQUksRUFBRSxRQUFRLEVBQUU7WUFDL0MsaUJBQWlCLEVBQUUsYUFBYSxLQUFLLDJCQUFhLENBQUMsT0FBTztZQUMxRCxhQUFhO1NBQ2QsQ0FBQyxDQUFDO1FBRUgsT0FBTyxJQUFJLG9DQUFzQixDQUFDLFFBQVEsQ0FBQyxNQUFNLENBQUMsQ0FBQztJQUNyRCxDQUFDOztBQTlHSCw0Q0ErR0M7OztBQU9ELE1BQWEsc0JBQXVCLFNBQVEsZ0JBQWdCO0lBQzFELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBa0M7UUFDMUUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUUsS0FBSyxDQUFDLENBQUM7SUFDMUIsQ0FBQzs7QUFISCx3REFJQzs7O0FBYUQsTUFBYSxlQUFnQixTQUFRLGdCQUFnQjtJQUNuRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQTJCO1FBQ25FLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFO1lBQ2YsR0FBRyxLQUFLO1lBQ1IsY0FBYyxFQUFFO2dCQUNkO29CQUNFLFVBQVUsRUFBRSxHQUFHO29CQUNmLGtCQUFrQixFQUFFLEdBQUc7b0JBQ3ZCLEdBQUcsRUFBRSxLQUFLLENBQUMsR0FBRyxJQUFJLHNCQUFRLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQztvQkFDdkMsZ0JBQWdCLEVBQUUsYUFBYTtpQkFDaEM7YUFDRjtTQUNGLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBYkgsMENBY0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xuICBEdXJhdGlvbixcbiAgUmVtb3ZhbFBvbGljeSxcbiAgU3RhY2ssXG4gIFJlc291cmNlRW52aXJvbm1lbnQsXG4gIENmblJlc291cmNlLFxuICBhd3NfY2VydGlmaWNhdGVtYW5hZ2VyLFxuICBhd3NfY2xvdWRmcm9udCxcbiAgYXdzX2Nsb3VkZnJvbnRfb3JpZ2lucyxcbiAgYXdzX3MzLFxufSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBJR3JhbnRhYmxlLCBHcmFudCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1pYW0nO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBJQ29uc3RydWN0IH0gZnJvbSAnY29uc3RydWN0cyc7XG5cbmltcG9ydCB7IElBdXRob3JpemF0aW9uLCBJU3RhdGljU2l0ZUF1dGhvcml6YXRpb24sIElTcGFBdXRob3JpemF0aW9uIH0gZnJvbSAnLi9hdXRob3JpemF0aW9ucyc7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ29tbW9uRGlzdHJpYnV0aW9uUHJvcHMge1xuICAvKipcbiAgICogVGhlIG9yaWdpbiB0aGF0IHlvdSB3YW50IENsb3VkRnJvbnQgdG8gcm91dGUgcmVxdWVzdHNcbiAgICovXG4gIHJlYWRvbmx5IG9yaWdpbj86IGF3c19jbG91ZGZyb250LklPcmlnaW47XG4gIC8qKlxuICAgKiBUaGUgcHJpY2UgY2xhc3MgdGhhdCBjb3JyZXNwb25kcyB3aXRoIHRoZSBtYXhpbXVtIHByaWNlIHRoYXQgeW91IHdhbnQgdG8gcGF5IGZvciBDbG91ZEZyb250IHNlcnZpY2UuXG4gICAqIElmIHlvdSBzcGVjaWZ5IFByaWNlQ2xhc3NfQWxsLCBDbG91ZEZyb250IHJlc3BvbmRzIHRvIHJlcXVlc3RzIGZvciB5b3VyIG9iamVjdHMgZnJvbSBhbGwgQ2xvdWRGcm9udCBlZGdlIGxvY2F0aW9ucy5cbiAgICogSWYgeW91IHNwZWNpZnkgYSBwcmljZSBjbGFzcyBvdGhlciB0aGFuIFByaWNlQ2xhc3NfQWxsLCBDbG91ZEZyb250IHNlcnZlcyB5b3VyIG9iamVjdHMgZnJvbSB0aGUgQ2xvdWRGcm9udCBlZGdlIGxvY2F0aW9uXG4gICAqIHRoYXQgaGFzIHRoZSBsb3dlc3QgbGF0ZW5jeSBhbW9uZyB0aGUgZWRnZSBsb2NhdGlvbnMgaW4geW91ciBwcmljZSBjbGFzcy5cbiAgICpcbiAgICogQGRlZmF1bHQgUHJpY2VDbGFzcy5QUklDRV9DTEFTU18xMDBcbiAgICovXG4gIHJlYWRvbmx5IHByaWNlQ2xhc3M/OiBhd3NfY2xvdWRmcm9udC5QcmljZUNsYXNzO1xuXG4gIC8qKlxuICAgKiBBbHRlcm5hdGl2ZSBkb21haW4gbmFtZXMgZm9yIHRoaXMgZGlzdHJpYnV0aW9uLlxuICAgKlxuICAgKiBJZiB5b3Ugd2FudCB0byB1c2UgeW91ciBvd24gZG9tYWluIG5hbWUsIHN1Y2ggYXMgd3d3LmV4YW1wbGUuY29tLCBpbnN0ZWFkIG9mIHRoZSBjbG91ZGZyb250Lm5ldCBkb21haW4gbmFtZSxcbiAgICogeW91IGNhbiBhZGQgYW4gYWx0ZXJuYXRlIGRvbWFpbiBuYW1lIHRvIHlvdXIgZGlzdHJpYnV0aW9uLiBJZiB5b3UgYXR0YWNoIGEgY2VydGlmaWNhdGUgdG8gdGhlIGRpc3RyaWJ1dGlvbixcbiAgICogeW91IG11c3QgYWRkIChhdCBsZWFzdCBvbmUgb2YpIHRoZSBkb21haW4gbmFtZXMgb2YgdGhlIGNlcnRpZmljYXRlIHRvIHRoaXMgbGlzdC5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBUaGUgZGlzdHJpYnV0aW9uIHdpbGwgb25seSBzdXBwb3J0IHRoZSBkZWZhdWx0IGdlbmVyYXRlZCBuYW1lIChlLmcuLCBkMTExMTExYWJjZGVmOC5jbG91ZGZyb250Lm5ldClcbiAgICovXG4gIHJlYWRvbmx5IGRvbWFpbk5hbWVzPzogc3RyaW5nW107XG5cbiAgLyoqXG4gICAqIEEgY2VydGlmaWNhdGUgdG8gYXNzb2NpYXRlIHdpdGggdGhlIGRpc3RyaWJ1dGlvbi4gVGhlIGNlcnRpZmljYXRlIG11c3QgYmUgbG9jYXRlZCBpbiBOLiBWaXJnaW5pYSAodXMtZWFzdC0xKS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSB0aGUgQ2xvdWRGcm9udCB3aWxkY2FyZCBjZXJ0aWZpY2F0ZSAoKi5jbG91ZGZyb250Lm5ldCkgd2lsbCBiZSB1c2VkLlxuICAgKi9cbiAgcmVhZG9ubHkgY2VydGlmaWNhdGU/OiBhd3NfY2VydGlmaWNhdGVtYW5hZ2VyLklDZXJ0aWZpY2F0ZTtcblxuICAvKipcbiAgICogQW55IGNvbW1lbnRzIHlvdSB3YW50IHRvIGluY2x1ZGUgYWJvdXQgdGhlIGRpc3RyaWJ1dGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBubyBjb21tZW50XG4gICAqL1xuICByZWFkb25seSBjb21tZW50Pzogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgb2JqZWN0IHRoYXQgeW91IHdhbnQgQ2xvdWRGcm9udCB0byByZXF1ZXN0IGZyb20geW91ciBvcmlnaW4gKGZvciBleGFtcGxlLCBpbmRleC5odG1sKVxuICAgKiB3aGVuIGEgdmlld2VyIHJlcXVlc3RzIHRoZSByb290IFVSTCBmb3IgeW91ciBkaXN0cmlidXRpb24uIElmIG5vIGRlZmF1bHQgb2JqZWN0IGlzIHNldCwgdGhlXG4gICAqIHJlcXVlc3QgZ29lcyB0byB0aGUgb3JpZ2luJ3Mgcm9vdCAoZS5nLiwgZXhhbXBsZS5jb20vKS5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBpbmRleC5odG1sXG4gICAqL1xuICByZWFkb25seSBkZWZhdWx0Um9vdE9iamVjdD86IHN0cmluZztcblxuICAvKipcbiAgICogRW5hYmxlIG9yIGRpc2FibGUgdGhlIGRpc3RyaWJ1dGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlZD86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIFdoZXRoZXIgQ2xvdWRGcm9udCB3aWxsIHJlc3BvbmQgdG8gSVB2NiBETlMgcmVxdWVzdHMgd2l0aCBhbiBJUHY2IGFkZHJlc3MuXG4gICAqXG4gICAqIElmIHlvdSBzcGVjaWZ5IGZhbHNlLCBDbG91ZEZyb250IHJlc3BvbmRzIHRvIElQdjYgRE5TIHJlcXVlc3RzIHdpdGggdGhlIEROUyByZXNwb25zZSBjb2RlIE5PRVJST1IgYW5kIHdpdGggbm8gSVAgYWRkcmVzc2VzLlxuICAgKiBUaGlzIGFsbG93cyB2aWV3ZXJzIHRvIHN1Ym1pdCBhIHNlY29uZCByZXF1ZXN0LCBmb3IgYW4gSVB2NCBhZGRyZXNzIGZvciB5b3VyIGRpc3RyaWJ1dGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgZW5hYmxlSXB2Nj86IGJvb2xlYW47XG5cbiAgLyoqXG4gICAqIEVuYWJsZSBhY2Nlc3MgbG9nZ2luZyBmb3IgdGhlIGRpc3RyaWJ1dGlvbi5cbiAgICpcbiAgICogQGRlZmF1bHQgLSBmYWxzZSwgdW5sZXNzIGBsb2dCdWNrZXRgIGlzIHNwZWNpZmllZC5cbiAgICovXG4gIHJlYWRvbmx5IGVuYWJsZUxvZ2dpbmc/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBUaGUgQW1hem9uIFMzIGJ1Y2tldCB0byBzdG9yZSB0aGUgYWNjZXNzIGxvZ3MgaW4uXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gQSBidWNrZXQgaXMgY3JlYXRlZCBpZiBgZW5hYmxlTG9nZ2luZ2AgaXMgdHJ1ZVxuICAgKi9cbiAgcmVhZG9ubHkgbG9nQnVja2V0PzogYXdzX3MzLklCdWNrZXQ7XG5cbiAgLyoqXG4gICAqIFNwZWNpZmllcyB3aGV0aGVyIHlvdSB3YW50IENsb3VkRnJvbnQgdG8gaW5jbHVkZSBjb29raWVzIGluIGFjY2VzcyBsb2dzXG4gICAqXG4gICAqIEBkZWZhdWx0IGZhbHNlXG4gICAqL1xuICByZWFkb25seSBsb2dJbmNsdWRlc0Nvb2tpZXM/OiBib29sZWFuO1xuXG4gIC8qKlxuICAgKiBBbiBvcHRpb25hbCBzdHJpbmcgdGhhdCB5b3Ugd2FudCBDbG91ZEZyb250IHRvIHByZWZpeCB0byB0aGUgYWNjZXNzIGxvZyBmaWxlbmFtZXMgZm9yIHRoaXMgZGlzdHJpYnV0aW9uLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIG5vIHByZWZpeFxuICAgKi9cbiAgcmVhZG9ubHkgbG9nRmlsZVByZWZpeD86IHN0cmluZztcblxuICAvKipcbiAgICogQ29udHJvbHMgdGhlIGNvdW50cmllcyBpbiB3aGljaCB5b3VyIGNvbnRlbnQgaXMgZGlzdHJpYnV0ZWQuXG4gICAqXG4gICAqIEBkZWZhdWx0IC0gTm8gZ2VvZ3JhcGhpYyByZXN0cmljdGlvbnNcbiAgICovXG4gIHJlYWRvbmx5IGdlb1Jlc3RyaWN0aW9uPzogYXdzX2Nsb3VkZnJvbnQuR2VvUmVzdHJpY3Rpb247XG5cbiAgLyoqXG4gICAqIFNwZWNpZnkgdGhlIG1heGltdW0gSFRUUCB2ZXJzaW9uIHRoYXQgeW91IHdhbnQgdmlld2VycyB0byB1c2UgdG8gY29tbXVuaWNhdGUgd2l0aCBDbG91ZEZyb250LlxuICAgKlxuICAgKiBGb3Igdmlld2VycyBhbmQgQ2xvdWRGcm9udCB0byB1c2UgSFRUUC8yLCB2aWV3ZXJzIG11c3Qgc3VwcG9ydCBUTFMgMS4yIG9yIGxhdGVyLCBhbmQgbXVzdCBzdXBwb3J0IHNlcnZlciBuYW1lIGlkZW50aWZpY2F0aW9uIChTTkkpLlxuICAgKlxuICAgKiBAZGVmYXVsdCBIdHRwVmVyc2lvbi5IVFRQMlxuICAgKi9cbiAgcmVhZG9ubHkgaHR0cFZlcnNpb24/OiBhd3NfY2xvdWRmcm9udC5IdHRwVmVyc2lvbjtcblxuICAvKipcbiAgICogVW5pcXVlIGlkZW50aWZpZXIgdGhhdCBzcGVjaWZpZXMgdGhlIEFXUyBXQUYgd2ViIEFDTCB0byBhc3NvY2lhdGUgd2l0aCB0aGlzIENsb3VkRnJvbnQgZGlzdHJpYnV0aW9uLlxuICAgKlxuICAgKiBUbyBzcGVjaWZ5IGEgd2ViIEFDTCBjcmVhdGVkIHVzaW5nIHRoZSBsYXRlc3QgdmVyc2lvbiBvZiBBV1MgV0FGLCB1c2UgdGhlIEFDTCBBUk4sIGZvciBleGFtcGxlXG4gICAqIGBhcm46YXdzOndhZnYyOnVzLWVhc3QtMToxMjM0NTY3ODkwMTI6Z2xvYmFsL3dlYmFjbC9FeGFtcGxlV2ViQUNMLzQ3M2U2NGZkLWYzMGItNDc2NS04MWEwLTYyYWQ5NmRkMTY3YWAuXG4gICAqIFRvIHNwZWNpZnkgYSB3ZWIgQUNMIGNyZWF0ZWQgdXNpbmcgQVdTIFdBRiBDbGFzc2ljLCB1c2UgdGhlIEFDTCBJRCwgZm9yIGV4YW1wbGUgYDQ3M2U2NGZkLWYzMGItNDc2NS04MWEwLTYyYWQ5NmRkMTY3YWAuXG4gICAqXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL3dhZi9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvd2hhdC1pcy1hd3Mtd2FmLmh0bWxcbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vY2xvdWRmcm9udC9sYXRlc3QvQVBJUmVmZXJlbmNlL0FQSV9DcmVhdGVEaXN0cmlidXRpb24uaHRtbCNBUElfQ3JlYXRlRGlzdHJpYnV0aW9uX1JlcXVlc3RQYXJhbWV0ZXJzLlxuICAgKlxuICAgKiBAZGVmYXVsdCAtIE5vIEFXUyBXZWIgQXBwbGljYXRpb24gRmlyZXdhbGwgd2ViIGFjY2VzcyBjb250cm9sIGxpc3QgKHdlYiBBQ0wpLlxuICAgKi9cbiAgcmVhZG9ubHkgd2ViQWNsSWQ/OiBzdHJpbmc7XG5cbiAgLyoqXG4gICAqIFRoZSBtaW5pbXVtIHZlcnNpb24gb2YgdGhlIFNTTCBwcm90b2NvbCB0aGF0IHlvdSB3YW50IENsb3VkRnJvbnQgdG8gdXNlIGZvciBIVFRQUyBjb25uZWN0aW9ucy5cbiAgICpcbiAgICogQ2xvdWRGcm9udCBzZXJ2ZXMgeW91ciBvYmplY3RzIG9ubHkgdG8gYnJvd3NlcnMgb3IgZGV2aWNlcyB0aGF0IHN1cHBvcnQgYXRcbiAgICogbGVhc3QgdGhlIFNTTCB2ZXJzaW9uIHRoYXQgeW91IHNwZWNpZnkuXG4gICAqXG4gICAqIEBkZWZhdWx0IFNlY3VyaXR5UG9saWN5UHJvdG9jb2wuVExTX1YxXzJfMjAxOVxuICAgKi9cbiAgcmVhZG9ubHkgbWluaW11bVByb3RvY29sVmVyc2lvbj86IGF3c19jbG91ZGZyb250LlNlY3VyaXR5UG9saWN5UHJvdG9jb2w7XG5cbiAgLyoqXG4gICAqIEBkZWZhdWx0IERlc3Ryb3lcbiAgICovXG4gIHJlYWRvbmx5IHJlbW92YWxQb2xpY3k/OiBSZW1vdmFsUG9saWN5O1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEJhc2VEaXN0cmlidXRpb25Qcm9wcyBleHRlbmRzIENvbW1vbkRpc3RyaWJ1dGlvblByb3BzIHtcbiAgcmVhZG9ubHkgYXV0aG9yaXphdGlvbjogSUF1dGhvcml6YXRpb247XG4gIHJlYWRvbmx5IGVycm9yUmVzcG9uc2VzPzogYXdzX2Nsb3VkZnJvbnQuRXJyb3JSZXNwb25zZVtdO1xufVxuXG5leHBvcnQgY2xhc3MgQmFzZURpc3RyaWJ1dGlvbiBleHRlbmRzIENvbnN0cnVjdCBpbXBsZW1lbnRzIGF3c19jbG91ZGZyb250LklEaXN0cmlidXRpb24ge1xuICBwdWJsaWMgcmVhZG9ubHkgZG9tYWluTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZGlzdHJpYnV0aW9uRG9tYWluTmFtZTogc3RyaW5nO1xuICBwdWJsaWMgcmVhZG9ubHkgZGlzdHJpYnV0aW9uSWQ6IHN0cmluZztcbiAgcHVibGljIHJlYWRvbmx5IHN0YWNrOiBTdGFjaztcbiAgcHVibGljIHJlYWRvbmx5IGVudjogUmVzb3VyY2VFbnZpcm9ubWVudDtcblxuICBwcml2YXRlIHJlYWRvbmx5IGRpc3RyaWJ1dGlvbjogYXdzX2Nsb3VkZnJvbnQuRGlzdHJpYnV0aW9uO1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBCYXNlRGlzdHJpYnV0aW9uUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgcmVtb3ZhbFBvbGljeSA9IHByb3BzLnJlbW92YWxQb2xpY3kgPz8gUmVtb3ZhbFBvbGljeS5ERVNUUk9ZO1xuICAgIGNvbnN0IG9yaWdpbiA9IHByb3BzLm9yaWdpbiA/PyB0aGlzLmRlZmF1bHRPcmlnaW4ocmVtb3ZhbFBvbGljeSk7XG5cbiAgICBjb25zdCBkaXN0cmlidXRpb24gPSBuZXcgYXdzX2Nsb3VkZnJvbnQuRGlzdHJpYnV0aW9uKHRoaXMsICdEaXN0cmlidXRpb24nLCB7XG4gICAgICBlbmFibGVkOiBwcm9wcy5lbmFibGVkID8/IHRydWUsXG4gICAgICBlbmFibGVJcHY2OiBwcm9wcy5lbmFibGVJcHY2ID8/IHRydWUsXG4gICAgICBjb21tZW50OiBwcm9wcy5jb21tZW50LFxuICAgICAgZW5hYmxlTG9nZ2luZzogcHJvcHMuZW5hYmxlTG9nZ2luZyxcbiAgICAgIGxvZ0J1Y2tldDogcHJvcHMubG9nQnVja2V0LFxuICAgICAgbG9nSW5jbHVkZXNDb29raWVzOiBwcm9wcy5sb2dJbmNsdWRlc0Nvb2tpZXMsXG4gICAgICBsb2dGaWxlUHJlZml4OiBwcm9wcy5sb2dGaWxlUHJlZml4LFxuICAgICAgcHJpY2VDbGFzczogcHJvcHMucHJpY2VDbGFzcyA/PyBhd3NfY2xvdWRmcm9udC5QcmljZUNsYXNzLlBSSUNFX0NMQVNTXzEwMCxcbiAgICAgIGdlb1Jlc3RyaWN0aW9uOiBwcm9wcy5nZW9SZXN0cmljdGlvbixcbiAgICAgIGh0dHBWZXJzaW9uOiBwcm9wcy5odHRwVmVyc2lvbiA/PyBhd3NfY2xvdWRmcm9udC5IdHRwVmVyc2lvbi5IVFRQMixcbiAgICAgIHdlYkFjbElkOiBwcm9wcy53ZWJBY2xJZCxcbiAgICAgIG1pbmltdW1Qcm90b2NvbFZlcnNpb246IHByb3BzLm1pbmltdW1Qcm90b2NvbFZlcnNpb24sXG4gICAgICBlcnJvclJlc3BvbnNlczogcHJvcHMuZXJyb3JSZXNwb25zZXMsXG4gICAgICBkb21haW5OYW1lczogcHJvcHMuZG9tYWluTmFtZXMsXG4gICAgICBjZXJ0aWZpY2F0ZTogcHJvcHMuY2VydGlmaWNhdGUsXG4gICAgICBkZWZhdWx0QmVoYXZpb3I6IHRoaXMucmVuZGVyRGVmYXVsdEJlaGF2aW91cihvcmlnaW4sIHByb3BzLmF1dGhvcml6YXRpb24pLFxuICAgICAgYWRkaXRpb25hbEJlaGF2aW9yczogdGhpcy5yZW5kZXJBZGRpdGlvbmFsQmVoYXZpb3JzKG9yaWdpbiwgcHJvcHMuYXV0aG9yaXphdGlvbiksXG4gICAgICBkZWZhdWx0Um9vdE9iamVjdDogcHJvcHMuZGVmYXVsdFJvb3RPYmplY3QgPz8gJ2luZGV4Lmh0bWwnLFxuICAgIH0pO1xuXG4gICAgdGhpcy5kaXN0cmlidXRpb24gPSBkaXN0cmlidXRpb247XG5cbiAgICBjb25zdCBjYWxsYmFja1VybHMgPVxuICAgICAgcHJvcHMuZG9tYWluTmFtZXM/Lm1hcCgobmFtZSkgPT4gYGh0dHBzOi8vJHtuYW1lfSR7cHJvcHMuYXV0aG9yaXphdGlvbi5yZWRpcmVjdFBhdGhzLnNpZ25Jbn1gKSA/PyBbXTtcbiAgICBjb25zdCBsb2dvdXRVcmxzID1cbiAgICAgIHByb3BzLmRvbWFpbk5hbWVzPy5tYXAoKG5hbWUpID0+IGBodHRwczovLyR7bmFtZX0ke3Byb3BzLmF1dGhvcml6YXRpb24ucmVkaXJlY3RQYXRocy5zaWduT3V0fWApID8/IFtdO1xuXG4gICAgcHJvcHMuYXV0aG9yaXphdGlvbi51cGRhdGVVc2VyUG9vbENsaWVudENhbGxiYWNrcyh7XG4gICAgICBjYWxsYmFja1VybHM6IFtcbiAgICAgICAgYGh0dHBzOi8vJHtkaXN0cmlidXRpb24uZGlzdHJpYnV0aW9uRG9tYWluTmFtZX0ke3Byb3BzLmF1dGhvcml6YXRpb24ucmVkaXJlY3RQYXRocy5zaWduSW59YCxcbiAgICAgICAgLi4uY2FsbGJhY2tVcmxzLFxuICAgICAgXSxcbiAgICAgIGxvZ291dFVybHM6IFtcbiAgICAgICAgYGh0dHBzOi8vJHtkaXN0cmlidXRpb24uZGlzdHJpYnV0aW9uRG9tYWluTmFtZX0ke3Byb3BzLmF1dGhvcml6YXRpb24ucmVkaXJlY3RQYXRocy5zaWduT3V0fWAsXG4gICAgICAgIC4uLmxvZ291dFVybHMsXG4gICAgICBdLFxuICAgIH0pO1xuXG4gICAgdGhpcy5kb21haW5OYW1lID0gZGlzdHJpYnV0aW9uLmRvbWFpbk5hbWU7XG4gICAgdGhpcy5kaXN0cmlidXRpb25Eb21haW5OYW1lID0gZGlzdHJpYnV0aW9uLmRpc3RyaWJ1dGlvbkRvbWFpbk5hbWU7XG4gICAgdGhpcy5kaXN0cmlidXRpb25JZCA9IGRpc3RyaWJ1dGlvbi5kaXN0cmlidXRpb25JZDtcblxuICAgIHRoaXMuc3RhY2sgPSBTdGFjay5vZih0aGlzKTtcbiAgICB0aGlzLmVudiA9IHtcbiAgICAgIGFjY291bnQ6IHRoaXMuc3RhY2suYWNjb3VudCxcbiAgICAgIHJlZ2lvbjogdGhpcy5zdGFjay5yZWdpb24sXG4gICAgfTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudChpZGVudGl0eTogSUdyYW50YWJsZSwgLi4uYWN0aW9uczogc3RyaW5nW10pOiBHcmFudCB7XG4gICAgcmV0dXJuIHRoaXMuZGlzdHJpYnV0aW9uLmdyYW50KGlkZW50aXR5LCAuLi5hY3Rpb25zKTtcbiAgfVxuXG4gIHB1YmxpYyBncmFudENyZWF0ZUludmFsaWRhdGlvbihpZGVudGl0eTogSUdyYW50YWJsZSk6IEdyYW50IHtcbiAgICByZXR1cm4gdGhpcy5kaXN0cmlidXRpb24uZ3JhbnRDcmVhdGVJbnZhbGlkYXRpb24oaWRlbnRpdHkpO1xuICB9XG5cbiAgcHVibGljIGFwcGx5UmVtb3ZhbFBvbGljeShwb2xpY3k6IFJlbW92YWxQb2xpY3kpIHtcbiAgICBjb25zdCBjaGlsZCA9IHRoaXMubm9kZS5kZWZhdWx0Q2hpbGQgYXMgSUNvbnN0cnVjdDtcbiAgICBpZiAoIWNoaWxkIHx8ICFDZm5SZXNvdXJjZS5pc0NmblJlc291cmNlKGNoaWxkKSkge1xuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICAnQ2Fubm90IGFwcGx5IFJlbW92YWxQb2xpY3k6IG5vIGNoaWxkIG9yIG5vdCBhIENmblJlc291cmNlLiBBcHBseSB0aGUgcmVtb3ZhbCBwb2xpY3kgb24gdGhlIENmblJlc291cmNlIGRpcmVjdGx5LicsXG4gICAgICApO1xuICAgIH1cbiAgICBjaGlsZC5hcHBseVJlbW92YWxQb2xpY3kocG9saWN5KTtcbiAgfVxuXG4gIHByb3RlY3RlZCByZW5kZXJEZWZhdWx0QmVoYXZpb3VyKFxuICAgIG9yaWdpbjogYXdzX2Nsb3VkZnJvbnQuSU9yaWdpbixcbiAgICBhdXRob3JpemF0aW9uOiBJQXV0aG9yaXphdGlvbixcbiAgKTogYXdzX2Nsb3VkZnJvbnQuQmVoYXZpb3JPcHRpb25zIHtcbiAgICByZXR1cm4gYXV0aG9yaXphdGlvbi5jcmVhdGVEZWZhdWx0QmVoYXZpb3Iob3JpZ2luLCB7XG4gICAgICBvcmlnaW5SZXF1ZXN0UG9saWN5OiB1bmRlZmluZWQsXG4gICAgICBjYWNoZVBvbGljeTogYXdzX2Nsb3VkZnJvbnQuQ2FjaGVQb2xpY3kuQ0FDSElOR19ESVNBQkxFRCxcbiAgICB9KTtcbiAgfVxuXG4gIHByb3RlY3RlZCByZW5kZXJBZGRpdGlvbmFsQmVoYXZpb3JzKFxuICAgIG9yaWdpbjogYXdzX2Nsb3VkZnJvbnQuSU9yaWdpbixcbiAgICBhdXRob3JpemF0aW9uOiBJQXV0aG9yaXphdGlvbixcbiAgKTogUmVjb3JkPHN0cmluZywgYXdzX2Nsb3VkZnJvbnQuQmVoYXZpb3JPcHRpb25zPiB7XG4gICAgcmV0dXJuIGF1dGhvcml6YXRpb24uY3JlYXRlQWRkaXRpb25hbEJlaGF2aW9ycyhvcmlnaW4sIHtcbiAgICAgIG9yaWdpblJlcXVlc3RQb2xpY3k6IHVuZGVmaW5lZCxcbiAgICAgIGNhY2hlUG9saWN5OiBhd3NfY2xvdWRmcm9udC5DYWNoZVBvbGljeS5DQUNISU5HX0RJU0FCTEVELFxuICAgIH0pO1xuICB9XG5cbiAgcHJpdmF0ZSBkZWZhdWx0T3JpZ2luKHJlbW92YWxQb2xpY3k6IFJlbW92YWxQb2xpY3kpOiBhd3NfY2xvdWRmcm9udC5JT3JpZ2luIHtcbiAgICBjb25zdCBidWNrZXQgPSBuZXcgYXdzX3MzLkJ1Y2tldCh0aGlzLCAnQnVja2V0Jywge1xuICAgICAgYXV0b0RlbGV0ZU9iamVjdHM6IHJlbW92YWxQb2xpY3kgPT09IFJlbW92YWxQb2xpY3kuREVTVFJPWSxcbiAgICAgIHJlbW92YWxQb2xpY3ksXG4gICAgfSk7XG5cbiAgICByZXR1cm4gbmV3IGF3c19jbG91ZGZyb250X29yaWdpbnMuUzNPcmlnaW4oYnVja2V0KTtcbiAgfVxufVxuXG5leHBvcnQgaW50ZXJmYWNlIFN0YXRpY1NpdGVEaXN0cmlidXRpb25Qcm9wcyBleHRlbmRzIENvbW1vbkRpc3RyaWJ1dGlvblByb3BzIHtcbiAgcmVhZG9ubHkgYXV0aG9yaXphdGlvbjogSVN0YXRpY1NpdGVBdXRob3JpemF0aW9uO1xuICByZWFkb25seSBlcnJvclJlc3BvbnNlcz86IGF3c19jbG91ZGZyb250LkVycm9yUmVzcG9uc2VbXTtcbn1cblxuZXhwb3J0IGNsYXNzIFN0YXRpY1NpdGVEaXN0cmlidXRpb24gZXh0ZW5kcyBCYXNlRGlzdHJpYnV0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFN0YXRpY1NpdGVEaXN0cmlidXRpb25Qcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuICB9XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgU3BhRGlzdHJpYnV0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25EaXN0cmlidXRpb25Qcm9wcyB7XG4gIHJlYWRvbmx5IGF1dGhvcml6YXRpb246IElTcGFBdXRob3JpemF0aW9uO1xuICAvKipcbiAgICogVGhlIG1pbmltdW0gYW1vdW50IG9mIHRpbWUsIGluIHNlY29uZHMsIHRoYXQgeW91IHdhbnQgQ2xvdWRGcm9udFxuICAgKiB0byBjYWNoZSB0aGUgSFRUUCBzdGF0dXMgY29kZSBzcGVjaWZpZWQgaW4gRXJyb3JDb2RlLlxuICAgKlxuICAgKiBAZGVmYXVsdCAzMDAgc2Vjb25kc1xuICAgKi9cbiAgcmVhZG9ubHkgdHRsPzogRHVyYXRpb247XG59XG5cbmV4cG9ydCBjbGFzcyBTcGFEaXN0cmlidXRpb24gZXh0ZW5kcyBCYXNlRGlzdHJpYnV0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IFNwYURpc3RyaWJ1dGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAuLi5wcm9wcyxcbiAgICAgIGVycm9yUmVzcG9uc2VzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBodHRwU3RhdHVzOiA0MDQsXG4gICAgICAgICAgcmVzcG9uc2VIdHRwU3RhdHVzOiAyMDAsXG4gICAgICAgICAgdHRsOiBwcm9wcy50dGwgPz8gRHVyYXRpb24uc2Vjb25kcygzMDApLFxuICAgICAgICAgIHJlc3BvbnNlUGFnZVBhdGg6ICcvaW5kZXguaHRtbCcsXG4gICAgICAgIH0sXG4gICAgICBdLFxuICAgIH0pO1xuICB9XG59XG4iXX0=