"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SecretGenerator = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class SecretGenerator extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        const secretGenerator = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'Function', {
            uuid: 'cloudcomponents-cdk-cloudfront-authorization-secret-generator',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            handler: 'index.handler',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'secret-generator')),
        });
        const cr = new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: secretGenerator.functionArn,
            resourceType: 'Custom::GenerateSecret',
            properties: {
                Length: props.length ?? 16,
                AllowedCharacters: props.allowedCharacters ?? 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~',
            },
        });
        this.secret = cr.ref;
    }
}
exports.SecretGenerator = SecretGenerator;
_a = JSII_RTTI_SYMBOL_1;
SecretGenerator[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.SecretGenerator", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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