"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.UserPoolClientRedirects = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class UserPoolClientRedirects extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'CognitoIdentityServiceProvider',
                action: 'updateUserPoolClient',
                parameters: {
                    UserPoolId: props.userPool.userPoolId,
                    ClientId: props.userPoolClient.userPoolClientId,
                    AllowedOAuthFlows: ['code'],
                    AllowedOAuthFlowsUserPoolClient: true,
                    SupportedIdentityProviders: props.identityProviders.map((provider) => provider.name),
                    AllowedOAuthScopes: props.oauthScopes.map((scope) => scope.scopeName),
                    CallbackURLs: props.callbackUrls,
                    LogoutURLs: props.logoutUrls,
                },
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(`${props.userPool.userPoolId}-${props.userPoolClient.userPoolClientId}-updated-client`),
            },
            policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.userPool.userPoolArn],
            }),
        });
    }
}
exports.UserPoolClientRedirects = UserPoolClientRedirects;
_a = JSII_RTTI_SYMBOL_1;
UserPoolClientRedirects[_a] = { fqn: "@cloudcomponents/cdk-cloudfront-authorization.UserPoolClientRedirects", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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