"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupBucket = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
class BackupBucket extends aws_s3_1.Bucket {
    constructor(scope, id, props) {
        const { retentionPeriod = aws_cdk_lib_1.Duration.days(35), ...rest } = props || {};
        super(scope, id, {
            lifecycleRules: [
                {
                    expiration: retentionPeriod,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.S3_MANAGED,
            publicReadAccess: false,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.RETAIN,
            ...rest,
        });
    }
}
exports.BackupBucket = BackupBucket;
_a = JSII_RTTI_SYMBOL_1;
BackupBucket[_a] = { fqn: "@cloudcomponents/cdk-codecommit-backup.BackupBucket", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYmFja3VwLWJ1Y2tldC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9iYWNrdXAtYnVja2V0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQXNEO0FBQ3RELCtDQUE4RjtBQU85RixNQUFhLFlBQWEsU0FBUSxlQUFNO0lBQ3RDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDakUsTUFBTSxFQUFFLGVBQWUsR0FBRyxzQkFBUSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsRUFBRSxHQUFHLElBQUksRUFBRSxHQUFHLEtBQUssSUFBSSxFQUFFLENBQUM7UUFFckUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixjQUFjLEVBQUU7Z0JBQ2Q7b0JBQ0UsVUFBVSxFQUFFLGVBQWU7aUJBQzVCO2FBQ0Y7WUFDRCxVQUFVLEVBQUUseUJBQWdCLENBQUMsVUFBVTtZQUN2QyxnQkFBZ0IsRUFBRSxLQUFLO1lBQ3ZCLGlCQUFpQixFQUFFLDBCQUFpQixDQUFDLFNBQVM7WUFDOUMsYUFBYSxFQUFFLDJCQUFhLENBQUMsTUFBTTtZQUNuQyxHQUFHLElBQUk7U0FDUixDQUFDLENBQUM7SUFDTCxDQUFDOztBQWhCSCxvQ0FpQkMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBEdXJhdGlvbiwgUmVtb3ZhbFBvbGljeSB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IEJsb2NrUHVibGljQWNjZXNzLCBCdWNrZXQsIEJ1Y2tldEVuY3J5cHRpb24sIEJ1Y2tldFByb3BzIH0gZnJvbSAnYXdzLWNkay1saWIvYXdzLXMzJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEJhY2t1cEJ1Y2tldFByb3BzIGV4dGVuZHMgQnVja2V0UHJvcHMge1xuICByZWFkb25seSByZXRlbnRpb25QZXJpb2Q/OiBEdXJhdGlvbjtcbn1cblxuZXhwb3J0IGNsYXNzIEJhY2t1cEJ1Y2tldCBleHRlbmRzIEJ1Y2tldCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogQmFja3VwQnVja2V0UHJvcHMpIHtcbiAgICBjb25zdCB7IHJldGVudGlvblBlcmlvZCA9IER1cmF0aW9uLmRheXMoMzUpLCAuLi5yZXN0IH0gPSBwcm9wcyB8fCB7fTtcblxuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgbGlmZWN5Y2xlUnVsZXM6IFtcbiAgICAgICAge1xuICAgICAgICAgIGV4cGlyYXRpb246IHJldGVudGlvblBlcmlvZCxcbiAgICAgICAgfSxcbiAgICAgIF0sXG4gICAgICBlbmNyeXB0aW9uOiBCdWNrZXRFbmNyeXB0aW9uLlMzX01BTkFHRUQsXG4gICAgICBwdWJsaWNSZWFkQWNjZXNzOiBmYWxzZSxcbiAgICAgIGJsb2NrUHVibGljQWNjZXNzOiBCbG9ja1B1YmxpY0FjY2Vzcy5CTE9DS19BTEwsXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LlJFVEFJTixcbiAgICAgIC4uLnJlc3QsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==