import { ComputeType } from 'aws-cdk-lib/aws-codebuild';
import { OnEventOptions, Rule, Schedule } from 'aws-cdk-lib/aws-events';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export interface FullRegionS3CodeCommitBackupProps {
    /**
     * Bucket for storing the backups.
     */
    readonly backupBucket: Bucket;
    /**
     * Schedule for backups.
     */
    readonly schedule: Schedule;
    /**
     * The names of the repositories in the region to be backed up.
     *
     * @default - All repositories in the region
     */
    readonly repositoryNames?: string[];
    /**
     * The type of compute to use for backup the repositories.
     *
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default taken from {@link #buildImage#defaultComputeType}
     */
    readonly computeType?: ComputeType;
}
export declare class FullRegionS3CodeCommitBackup extends Construct {
    private readonly backupProject;
    constructor(scope: Construct, id: string, props: FullRegionS3CodeCommitBackupProps);
    /**
     * Defines an event rule which triggers when a backup fails.
     */
    onBackupFailed(id: string, options?: OnEventOptions): Rule;
    /**
     * Defines an event rule which triggers when a backup starts.
     */
    onBackupStarted(id: string, options?: OnEventOptions): Rule;
    /**
     * Defines an event rule which triggers when a backup complets successfully.
     */
    onBackupSucceeded(id: string, options?: OnEventOptions): Rule;
}
