import { ComputeType } from 'aws-cdk-lib/aws-codebuild';
import { IRepository } from 'aws-cdk-lib/aws-codecommit';
import { OnEventOptions, Rule, Schedule } from 'aws-cdk-lib/aws-events';
import { Bucket } from 'aws-cdk-lib/aws-s3';
import { Construct } from 'constructs';
export interface S3CodeCommitBackupProps {
    /**
     * Bucket for storing the backups.
     */
    readonly backupBucket: Bucket;
    /**
     * Schedule for backups.
     */
    readonly schedule: Schedule;
    /**
     * Repository to be backed up.
     */
    readonly repository: IRepository;
    /**
     * The type of compute to use for backup the repositories.
     *
     * See the {@link ComputeType} enum for the possible values.
     *
     * @default taken from {@link #buildImage#defaultComputeType}
     */
    readonly computeType?: ComputeType;
}
export declare class S3CodeCommitBackup extends Construct {
    private readonly backupProject;
    constructor(scope: Construct, id: string, props: S3CodeCommitBackupProps);
    /**
     * Defines an event rule which triggers when a backup fails.
     */
    onBackupFailed(id: string, options?: OnEventOptions): Rule;
    /**
     * Defines an event rule which triggers when a backup starts.
     */
    onBackupStarted(id: string, options?: OnEventOptions): Rule;
    /**
     * Defines an event rule which triggers when a backup complets successfully.
     */
    onBackupSucceeded(id: string, options?: OnEventOptions): Rule;
}
