"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhook = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
class GithubWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '83CBF3EB-7B62-44F2-8C67-8441E4C1232E',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'github-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::GithubWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        const { githubApiToken, githubRepoUrl, payloadUrl, events, logLevel, } = props;
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::GithubWebhook',
            properties: {
                GithubApiToken: githubApiToken,
                GithubRepoUrl: githubRepoUrl,
                PayloadUrl: payloadUrl,
                Events: events,
                LogLevel: logLevel,
            },
        });
    }
}
exports.GithubWebhook = GithubWebhook;
//# sourceMappingURL=data:application/json;base64,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