"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhook = void 0;
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
class GithubWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '83CBF3EB-7B62-44F2-8C67-8441E4C1232E',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'github-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::GithubWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        const { githubApiToken, githubRepoUrl, payloadUrl, events, logLevel } = props;
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::GithubWebhook',
            properties: {
                GithubApiToken: githubApiToken,
                GithubRepoUrl: githubRepoUrl,
                PayloadUrl: payloadUrl,
                Events: events,
                LogLevel: logLevel,
            },
        });
    }
}
exports.GithubWebhook = GithubWebhook;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZ2l0aHViLXdlYmhvb2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi9zcmMvZ2l0aHViLXdlYmhvb2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkJBQTZCO0FBQzdCLG9EQUF1RTtBQUN2RSx3Q0FBb0U7QUEyQnBFLE1BQWEsYUFBYyxTQUFRLGdCQUFTO0lBQzFDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDakUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVqQixNQUFNLE9BQU8sR0FBRyxJQUFJLDhCQUFpQixDQUFDLElBQUksRUFBRSx1QkFBdUIsRUFBRTtZQUNuRSxJQUFJLEVBQUUsc0NBQXNDO1lBQzVDLE9BQU8sRUFBRSxvQkFBTyxDQUFDLFdBQVc7WUFDNUIsSUFBSSxFQUFFLGlCQUFJLENBQUMsU0FBUyxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLFNBQVMsRUFBRSxnQkFBZ0IsQ0FBQyxDQUFDO1lBQ3ZFLE9BQU8sRUFBRSxlQUFlO1lBQ3hCLGFBQWEsRUFBRSx1QkFBdUI7WUFDdEMsT0FBTyxFQUFFLGVBQVEsQ0FBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1NBQzlCLENBQUMsQ0FBQztRQUVILE1BQU0sRUFBRSxjQUFjLEVBQUUsYUFBYSxFQUFFLFVBQVUsRUFBRSxNQUFNLEVBQUUsUUFBUSxFQUFFLEdBQUcsS0FBSyxDQUFDO1FBRTlFLElBQUkscUJBQWMsQ0FBQyxJQUFJLEVBQUUsZ0JBQWdCLEVBQUU7WUFDekMsWUFBWSxFQUFFLE9BQU8sQ0FBQyxXQUFXO1lBQ2pDLFlBQVksRUFBRSx1QkFBdUI7WUFDckMsVUFBVSxFQUFFO2dCQUNWLGNBQWMsRUFBRSxjQUFjO2dCQUM5QixhQUFhLEVBQUUsYUFBYTtnQkFDNUIsVUFBVSxFQUFFLFVBQVU7Z0JBQ3RCLE1BQU0sRUFBRSxNQUFNO2dCQUNkLFFBQVEsRUFBRSxRQUFRO2FBQ25CO1NBQ0YsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBM0JELHNDQTJCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBTaW5nbGV0b25GdW5jdGlvbiwgUnVudGltZSwgQ29kZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0LCBEdXJhdGlvbiwgQ3VzdG9tUmVzb3VyY2UgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcblxuZXhwb3J0IGludGVyZmFjZSBHaXRodWJXZWJob29rUHJvcHMge1xuICAvKipcbiAgICogVGhlIE9BdXRoIGFjY2VzcyB0b2tlblxuICAgKi9cbiAgcmVhZG9ubHkgZ2l0aHViQXBpVG9rZW46IHN0cmluZztcblxuICAvKipcbiAgICogVGhlIEdpdGh1YiByZXBvIHVybFxuICAgKi9cbiAgcmVhZG9ubHkgZ2l0aHViUmVwb1VybDogc3RyaW5nO1xuXG4gIC8qKlxuICAgKiBUaGUgVVJMIHRvIHdoaWNoIHRoZSBwYXlsb2FkcyB3aWxsIGJlIGRlbGl2ZXJlZC5cbiAgICovXG4gIHJlYWRvbmx5IHBheWxvYWRVcmw6IHN0cmluZztcblxuICAvKipcbiAgICogRGV0ZXJtaW5lcyB3aGF0IGV2ZW50cyB0aGUgaG9vayBpcyB0cmlnZ2VyZWQgZm9yLlxuICAgKiBAc2VlIGh0dHBzOi8vZGV2ZWxvcGVyLmdpdGh1Yi5jb20vdjMvYWN0aXZpdHkvZXZlbnRzL3R5cGVzL1xuICAgKi9cbiAgcmVhZG9ubHkgZXZlbnRzOiBzdHJpbmdbXTtcblxuICByZWFkb25seSBsb2dMZXZlbD86ICdkZWJ1ZycgfCAnaW5mbycgfCAnd2FybmluZycgfCAnZXJyb3InO1xufVxuXG5leHBvcnQgY2xhc3MgR2l0aHViV2ViaG9vayBleHRlbmRzIENvbnN0cnVjdCB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBHaXRodWJXZWJob29rUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgaGFuZGxlciA9IG5ldyBTaW5nbGV0b25GdW5jdGlvbih0aGlzLCAnQ3VzdG9tUmVzb3VyY2VIYW5kbGVyJywge1xuICAgICAgdXVpZDogJzgzQ0JGM0VCLTdCNjItNDRGMi04QzY3LTg0NDFFNEMxMjMyRScsXG4gICAgICBydW50aW1lOiBSdW50aW1lLk5PREVKU18xMl9YLFxuICAgICAgY29kZTogQ29kZS5mcm9tQXNzZXQocGF0aC5qb2luKF9fZGlybmFtZSwgJ2xhbWJkYXMnLCAnZ2l0aHViLXdlYmhvb2snKSksXG4gICAgICBoYW5kbGVyOiAnaW5kZXguaGFuZGxlcicsXG4gICAgICBsYW1iZGFQdXJwb3NlOiAnQ3VzdG9tOjpHaXRodWJXZWJob29rJyxcbiAgICAgIHRpbWVvdXQ6IER1cmF0aW9uLm1pbnV0ZXMoMTUpLFxuICAgIH0pO1xuXG4gICAgY29uc3QgeyBnaXRodWJBcGlUb2tlbiwgZ2l0aHViUmVwb1VybCwgcGF5bG9hZFVybCwgZXZlbnRzLCBsb2dMZXZlbCB9ID0gcHJvcHM7XG5cbiAgICBuZXcgQ3VzdG9tUmVzb3VyY2UodGhpcywgJ0N1c3RvbVJlc291cmNlJywge1xuICAgICAgc2VydmljZVRva2VuOiBoYW5kbGVyLmZ1bmN0aW9uQXJuLFxuICAgICAgcmVzb3VyY2VUeXBlOiAnQ3VzdG9tOjpHaXRodWJXZWJob29rJyxcbiAgICAgIHByb3BlcnRpZXM6IHtcbiAgICAgICAgR2l0aHViQXBpVG9rZW46IGdpdGh1YkFwaVRva2VuLFxuICAgICAgICBHaXRodWJSZXBvVXJsOiBnaXRodWJSZXBvVXJsLFxuICAgICAgICBQYXlsb2FkVXJsOiBwYXlsb2FkVXJsLFxuICAgICAgICBFdmVudHM6IGV2ZW50cyxcbiAgICAgICAgTG9nTGV2ZWw6IGxvZ0xldmVsLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19