"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
class GithubWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const githubApiToken = typeof props.githubApiToken === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.githubApiToken) : props.githubApiToken;
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '83CBF3EB-7B62-44F2-8C67-8441E4C1232E',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'github-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::GithubWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        if (githubApiToken.grantRead) {
            githubApiToken.grantRead(handler);
        }
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::GithubWebhook',
            pascalCaseProperties: true,
            properties: {
                githubApiTokenString: githubApiToken.serialize(),
                githubRepoUrl: props.githubRepoUrl,
                payloadUrl: props.payloadUrl,
                events: props.events,
                logLevel: props.logLevel,
            },
        });
    }
}
exports.GithubWebhook = GithubWebhook;
_a = JSII_RTTI_SYMBOL_1;
GithubWebhook[_a] = { fqn: "@cloudcomponents/cdk-github-webhook.GithubWebhook", version: "1.36.0" };
//# sourceMappingURL=data:application/json;base64,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