"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class GithubWebhook extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const githubApiToken = typeof props.githubApiToken === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.githubApiToken) : props.githubApiToken;
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '83CBF3EB-7B62-44F2-8C67-8441E4C1232E',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'github-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::GithubWebhook',
            timeout: aws_cdk_lib_1.Duration.minutes(15),
        });
        if (githubApiToken.grantRead) {
            githubApiToken.grantRead(handler);
        }
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::GithubWebhook',
            pascalCaseProperties: true,
            properties: {
                githubApiTokenString: githubApiToken.serialize(),
                githubRepoUrl: props.githubRepoUrl,
                payloadUrl: props.payloadUrl,
                events: props.events,
                logLevel: props.logLevel,
            },
        });
    }
}
exports.GithubWebhook = GithubWebhook;
_a = JSII_RTTI_SYMBOL_1;
GithubWebhook[_a] = { fqn: "@cloudcomponents/cdk-github-webhook.GithubWebhook", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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