"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class GithubWebhook extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const githubApiToken = typeof props.githubApiToken === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.githubApiToken) : props.githubApiToken;
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '83CBF3EB-7B62-44F2-8C67-8441E4C1232E',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'github-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::GithubWebhook',
            timeout: aws_cdk_lib_1.Duration.minutes(15),
        });
        if (githubApiToken.grantRead) {
            githubApiToken.grantRead(handler);
        }
        new aws_cdk_lib_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::GithubWebhook',
            pascalCaseProperties: true,
            properties: {
                githubApiTokenString: githubApiToken.serialize(),
                githubRepoUrl: props.githubRepoUrl,
                payloadUrl: props.payloadUrl,
                events: props.events,
                logLevel: props.logLevel,
            },
        });
    }
}
exports.GithubWebhook = GithubWebhook;
_a = JSII_RTTI_SYMBOL_1;
GithubWebhook[_a] = { fqn: "@cloudcomponents/cdk-github-webhook.GithubWebhook", version: "2.4.0" };
//# sourceMappingURL=data:application/json;base64,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