import { Construct } from '@aws-cdk/core';
import { Code, IFunction } from '@aws-cdk/aws-lambda';
import { IRole } from '@aws-cdk/aws-iam';
import { LogLevel } from './with-configuration';
export interface CommonEdgeFunctionProps {
    readonly role?: IRole;
    readonly logLevel?: LogLevel;
    /**
     * The name of the parameter.
     */
    readonly parameterName?: string;
    readonly [key: string]: unknown;
}
export interface EdgeFunctionProps extends CommonEdgeFunctionProps {
    readonly code: Code;
    readonly name: string;
}
export declare class EdgeFunction extends Construct {
    readonly role: IRole;
    private readonly stack;
    private readonly parameter;
    constructor(scope: Construct, id: string, props: EdgeFunctionProps);
    retrieveEdgeFunction(scope: Construct): IFunction;
    private requireApp;
    private getOrCreateCrossRegionSupportStack;
    private getCrossRegionSupportSynthesizer;
}
