import { Construct } from '@aws-cdk/core';
import { Code, IFunction } from '@aws-cdk/aws-lambda';
import { IRole } from '@aws-cdk/aws-iam';
import { LogLevel } from './with-configuration';
export interface CommonLambdaAtEdgeProps {
    readonly role?: IRole;
    readonly logLevel?: LogLevel;
    /**
     * The name of the parameter.
     */
    readonly parameterName?: string;
    readonly [key: string]: unknown;
}
export interface LambdaAtEdgeProps extends CommonLambdaAtEdgeProps {
    readonly code: Code;
    readonly name: string;
}
export declare class LambdaAtEdge extends Construct {
    private readonly stack;
    private readonly parameter;
    constructor(scope: Construct, id: string, props: LambdaAtEdgeProps);
    retrieve(scope: Construct): IFunction;
    private requireApp;
    private getCrossRegionSupportSynthesizer;
}
