// modules are defined as an array
// [ module function, map of requires ]
//
// map of requires is short require name -> numeric require
//
// anything defined in a previous bundle is accessed via the
// orig method which is the require for previous bundles
parcelRequire = (function (modules, cache, entry, globalName) {
  // Save the require from previous bundle to this closure if any
  var previousRequire = typeof parcelRequire === 'function' && parcelRequire;
  var nodeRequire = typeof require === 'function' && require;

  function newRequire(name, jumped) {
    if (!cache[name]) {
      if (!modules[name]) {
        // if we cannot find the module within our internal map or
        // cache jump to the current global require ie. the last bundle
        // that was added to the page.
        var currentRequire = typeof parcelRequire === 'function' && parcelRequire;
        if (!jumped && currentRequire) {
          return currentRequire(name, true);
        }

        // If there are other bundles on this page the require from the
        // previous one is saved to 'previousRequire'. Repeat this as
        // many times as there are bundles until the module is found or
        // we exhaust the require chain.
        if (previousRequire) {
          return previousRequire(name, true);
        }

        // Try the node require function if it exists.
        if (nodeRequire && typeof name === 'string') {
          return nodeRequire(name);
        }

        var err = new Error('Cannot find module \'' + name + '\'');
        err.code = 'MODULE_NOT_FOUND';
        throw err;
      }

      localRequire.resolve = resolve;
      localRequire.cache = {};

      var module = cache[name] = new newRequire.Module(name);

      modules[name][0].call(module.exports, localRequire, module, module.exports, this);
    }

    return cache[name].exports;

    function localRequire(x){
      return newRequire(localRequire.resolve(x));
    }

    function resolve(x){
      return modules[name][1][x] || x;
    }
  }

  function Module(moduleName) {
    this.id = moduleName;
    this.bundle = newRequire;
    this.exports = {};
  }

  newRequire.isParcelRequire = true;
  newRequire.Module = Module;
  newRequire.modules = modules;
  newRequire.cache = cache;
  newRequire.parent = previousRequire;
  newRequire.register = function (id, exports) {
    modules[id] = [function (require, module) {
      module.exports = exports;
    }, {}];
  };

  var error;
  for (var i = 0; i < entry.length; i++) {
    try {
      newRequire(entry[i]);
    } catch (e) {
      // Save first error but execute all entries
      if (!error) {
        error = e;
      }
    }
  }

  if (entry.length) {
    // Expose entry point to Node, AMD or browser globals
    // Based on https://github.com/ForbesLindesay/umd/blob/master/template.js
    var mainExports = newRequire(entry[entry.length - 1]);

    // CommonJS
    if (typeof exports === "object" && typeof module !== "undefined") {
      module.exports = mainExports;

    // RequireJS
    } else if (typeof define === "function" && define.amd) {
     define(function () {
       return mainExports;
     });

    // <script>
    } else if (globalName) {
      this[globalName] = mainExports;
    }
  }

  // Override the current require with this new one
  parcelRequire = newRequire;

  if (error) {
    // throw error from earlier, _after updating parcelRequire_
    throw error;
  }

  return newRequire;
})({"../shared/index.ts":[function(require,module,exports) {
"use strict";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConfig = void 0;

const fs_1 = require("fs");

var LogLevel;

(function (LogLevel) {
  LogLevel[LogLevel["none"] = 0] = "none";
  LogLevel[LogLevel["error"] = 10] = "error";
  LogLevel[LogLevel["warn"] = 20] = "warn";
  LogLevel[LogLevel["info"] = 30] = "info";
  LogLevel[LogLevel["debug"] = 40] = "debug";
})(LogLevel || (LogLevel = {}));

class Logger {
  constructor(logLevel) {
    this.logLevel = logLevel;
  }

  jsonify(...args) {
    return args.map(arg => {
      if (typeof arg === 'object') {
        try {
          return JSON.stringify(arg);
        } catch (_a) {
          return arg;
        }
      }

      return arg;
    });
  }

  info(...args) {
    if (this.logLevel >= LogLevel.info) {
      console.log(...this.jsonify(args));
    }
  }

  warn(...args) {
    if (this.logLevel >= LogLevel.warn) {
      console.warn(...this.jsonify(args));
    }
  }

  error(...args) {
    if (this.logLevel >= LogLevel.error) {
      console.error(...this.jsonify(args));
    }
  }

  debug(...args) {
    if (this.logLevel >= LogLevel.debug) {
      console.trace(...this.jsonify(args));
    }
  }

}

function getConfig() {
  const config = JSON.parse(fs_1.readFileSync(`${__dirname}/configuration.json`).toString('utf8')); // Setup logger

  const logger = new Logger(LogLevel[config.logLevel]);
  return _objectSpread(_objectSpread({}, config), {}, {
    logger
  });
}

exports.getConfig = getConfig;
},{}],"index.ts":[function(require,module,exports) {
"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.handler = void 0;

const shared_1 = require("../shared");

let CONFIG;

exports.handler = async event => {
  if (!CONFIG) {
    CONFIG = shared_1.getConfig();
  }

  CONFIG.logger.debug(event);
  const response = event.Records[0].cf.response;
  Object.assign(response.headers, asCloudFrontHeaders(CONFIG.httpHeaders));
  CONFIG.logger.debug('Returning response:\n', response);
  return response;
};

function asCloudFrontHeaders(headers) {
  return Object.entries(headers).reduce((reduced, [key, value]) => Object.assign(reduced, {
    [key.toLowerCase()]: [{
      key,
      value
    }]
  }), {});
}
},{"../shared":"../shared/index.ts"}]},{},["index.ts"], null)
//# sourceMappingURL=/index.js.map