"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpHeaders = void 0;
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
// Blacklisted headers aren't exposed and can't be added by Lambda@Edge functions:
// https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-requirements-limits.html#lambda-blacklisted-headers
const BLACKLISTED_HEADERS = [
    /^connection$/i,
    /^expect$/i,
    /^keep-alive$/i,
    /^proxy-authenticate$/i,
    /^proxy-authorization$/i,
    /^proxy-connection$/i,
    /^trailer$/i,
    /^upgrade$/i,
    /^x-accel-buffering$/i,
    /^x-accel-charset$/i,
    /^x-accel-limit-rate$/i,
    /^x-accel-redirect$/i,
    /^X-Amz-Cf-.*/i,
    /^X-Amzn-.*/i,
    /^X-Cache.*/i,
    /^X-Edge-.*/i,
    /^X-Forwarded-Proto.*/i,
    /^X-Real-IP$/i,
];
class HttpHeaders extends edge_function_1.EdgeFunction {
    constructor(scope, id, props) {
        var _a;
        super(scope, id, {
            name: 'http-headers',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'http-headers')),
            eventType: aws_cloudfront_1.LambdaEdgeEventType.ORIGIN_RESPONSE,
            configuration: {
                logLevel: (_a = props.logLevel) !== null && _a !== void 0 ? _a : with_configuration_1.LogLevel.WARN,
                httpHeaders: props.httpHeaders,
            },
        });
        Object.keys(props.httpHeaders).forEach((header) => {
            if (BLACKLISTED_HEADERS.some((blheader) => blheader.test(header))) {
                throw new Error(`HttpHeader ${header} is blacklisted and can't be added by Lambda@Edge functions`);
            }
        });
    }
}
exports.HttpHeaders = HttpHeaders;
//# sourceMappingURL=data:application/json;base64,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