import { Construct } from '@aws-cdk/core';
import { IFunction, IVersion } from '@aws-cdk/aws-lambda';
export declare enum LogLevel {
    NONE = "none",
    INFO = "info",
    WARN = "warn",
    ERROR = "error",
    DEBUG = "debug"
}
export interface Configuration {
    readonly logLevel: LogLevel;
    readonly [key: string]: unknown;
}
export interface WithConfigurationProps {
    readonly function: IFunction;
    readonly configuration: Configuration;
}
export declare class WithConfiguration extends Construct {
    readonly functionVersion: IVersion;
    constructor(scope: Construct, id: string, props: WithConfigurationProps);
}
