"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.WithConfiguration = exports.LogLevel = void 0;
const path = require("path");
const core_1 = require("@aws-cdk/core");
const aws_iam_1 = require("@aws-cdk/aws-iam");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
var LogLevel;
(function (LogLevel) {
    LogLevel["NONE"] = "none";
    LogLevel["INFO"] = "info";
    LogLevel["WARN"] = "warn";
    LogLevel["ERROR"] = "error";
    LogLevel["DEBUG"] = "debug";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
class WithConfiguration extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resourceType = 'Custom::WithConfiguration';
        const handler = new aws_lambda_1.SingletonFunction(this, 'Handler', {
            uuid: 'cloudcomponents-cdk-lambda-at-edge-pattern-with-configuration',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'with-configuration')),
            handler: 'index.handler',
            lambdaPurpose: resourceType,
            timeout: core_1.Duration.minutes(5),
        });
        handler.addToRolePolicy(new aws_iam_1.PolicyStatement({
            effect: aws_iam_1.Effect.ALLOW,
            actions: ['lambda:GetFunction', 'lambda:UpdateFunctionCode'],
            resources: [props.function.functionArn],
        }));
        const cr = new core_1.CustomResource(this, 'WithConfiguration', {
            serviceToken: handler.functionArn,
            resourceType,
            properties: {
                Region: 'us-east-1',
                FunctionName: props.function.functionName,
                Configuration: JSON.stringify(props.configuration, null, 2),
            },
        });
        this.functionVersion = aws_lambda_1.Version.fromVersionArn(this, 'Version', cr.getAttString('FunctionArn'));
    }
}
exports.WithConfiguration = WithConfiguration;
//# sourceMappingURL=data:application/json;base64,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