"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpHeaders = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
// Blacklisted headers aren't exposed and can't be added by Lambda@Edge functions:
// https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-requirements-limits.html#lambda-blacklisted-headers
const BLACKLISTED_HEADERS = [
    /^connection$/i,
    /^expect$/i,
    /^keep-alive$/i,
    /^proxy-authenticate$/i,
    /^proxy-authorization$/i,
    /^proxy-connection$/i,
    /^trailer$/i,
    /^upgrade$/i,
    /^x-accel-buffering$/i,
    /^x-accel-charset$/i,
    /^x-accel-limit-rate$/i,
    /^x-accel-redirect$/i,
    /^X-Amz-Cf-.*/i,
    /^X-Amzn-.*/i,
    /^X-Cache.*/i,
    /^X-Edge-.*/i,
    /^X-Forwarded-Proto.*/i,
    /^X-Real-IP$/i,
];
class HttpHeaders extends edge_function_1.EdgeFunction {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, {
            name: 'http-headers',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'http-headers')),
            eventType: aws_cloudfront_1.LambdaEdgeEventType.ORIGIN_RESPONSE,
            edgeRole: props.edgeRole,
            configuration: {
                logLevel: (_b = props.logLevel) !== null && _b !== void 0 ? _b : with_configuration_1.LogLevel.WARN,
                httpHeaders: props.httpHeaders,
            },
        });
        Object.keys(props.httpHeaders).forEach((header) => {
            if (BLACKLISTED_HEADERS.some((blheader) => blheader.test(header))) {
                throw new Error(`HttpHeader ${header} is blacklisted and can't be added by Lambda@Edge functions`);
            }
        });
    }
}
exports.HttpHeaders = HttpHeaders;
_a = JSII_RTTI_SYMBOL_1;
HttpHeaders[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.HttpHeaders", version: "1.40.0" };
//# sourceMappingURL=data:application/json;base64,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