"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.OriginMutation = void 0;
const path = require("path");
const aws_cloudfront_1 = require("@aws-cdk/aws-cloudfront");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
class OriginMutation extends edge_function_1.EdgeFunction {
    constructor(scope, id, props = {}) {
        var _a;
        super(scope, id, {
            name: 'origin-mutation',
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'origin-mutation')),
            eventType: aws_cloudfront_1.LambdaEdgeEventType.ORIGIN_REQUEST,
            edgeRole: props.edgeRole,
            configuration: {
                logLevel: (_a = props.logLevel) !== null && _a !== void 0 ? _a : with_configuration_1.LogLevel.WARN,
            },
        });
    }
}
exports.OriginMutation = OriginMutation;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoib3JpZ2luLW11dGF0aW9uLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vc3JjL29yaWdpbi1tdXRhdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSw2QkFBNkI7QUFDN0IsNERBQThEO0FBQzlELG9EQUEyQztBQUczQyxtREFBd0U7QUFDeEUsNkRBQWdEO0FBTWhELE1BQWEsY0FBZSxTQUFRLDRCQUFZO0lBQzlDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsUUFBNkIsRUFBRTs7UUFDdkUsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDZixJQUFJLEVBQUUsaUJBQWlCO1lBQ3ZCLElBQUksRUFBRSxpQkFBSSxDQUFDLFNBQVMsQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxTQUFTLEVBQUUsaUJBQWlCLENBQUMsQ0FBQztZQUN4RSxTQUFTLEVBQUUsb0NBQW1CLENBQUMsY0FBYztZQUM3QyxRQUFRLEVBQUUsS0FBSyxDQUFDLFFBQVE7WUFDeEIsYUFBYSxFQUFFO2dCQUNiLFFBQVEsUUFBRSxLQUFLLENBQUMsUUFBUSxtQ0FBSSw2QkFBUSxDQUFDLElBQUk7YUFDMUM7U0FDRixDQUFDLENBQUM7SUFDTCxDQUFDO0NBQ0Y7QUFaRCx3Q0FZQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIHBhdGggZnJvbSAncGF0aCc7XG5pbXBvcnQgeyBMYW1iZGFFZGdlRXZlbnRUeXBlIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnO1xuaW1wb3J0IHsgQ29kZSB9IGZyb20gJ0Bhd3MtY2RrL2F3cy1sYW1iZGEnO1xuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbmltcG9ydCB7IEVkZ2VGdW5jdGlvbiwgQ29tbW9uRWRnZUZ1bmN0aW9uUHJvcHMgfSBmcm9tICcuL2VkZ2UtZnVuY3Rpb24nO1xuaW1wb3J0IHsgTG9nTGV2ZWwgfSBmcm9tICcuL3dpdGgtY29uZmlndXJhdGlvbic7XG5cbmV4cG9ydCBpbnRlcmZhY2UgT3JpZ2luTXV0YXRpb25Qcm9wcyBleHRlbmRzIENvbW1vbkVkZ2VGdW5jdGlvblByb3BzIHtcbiAgcmVhZG9ubHkgbG9nTGV2ZWw/OiBMb2dMZXZlbDtcbn1cblxuZXhwb3J0IGNsYXNzIE9yaWdpbk11dGF0aW9uIGV4dGVuZHMgRWRnZUZ1bmN0aW9uIHtcbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IE9yaWdpbk11dGF0aW9uUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwge1xuICAgICAgbmFtZTogJ29yaWdpbi1tdXRhdGlvbicsXG4gICAgICBjb2RlOiBDb2RlLmZyb21Bc3NldChwYXRoLmpvaW4oX19kaXJuYW1lLCAnbGFtYmRhcycsICdvcmlnaW4tbXV0YXRpb24nKSksXG4gICAgICBldmVudFR5cGU6IExhbWJkYUVkZ2VFdmVudFR5cGUuT1JJR0lOX1JFUVVFU1QsXG4gICAgICBlZGdlUm9sZTogcHJvcHMuZWRnZVJvbGUsXG4gICAgICBjb25maWd1cmF0aW9uOiB7XG4gICAgICAgIGxvZ0xldmVsOiBwcm9wcy5sb2dMZXZlbCA/PyBMb2dMZXZlbC5XQVJOLFxuICAgICAgfSxcbiAgICB9KTtcbiAgfVxufVxuIl19