"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const aws_ssm_1 = require("@aws-cdk/aws-ssm");
const base_edge_construct_1 = require("./base-edge-construct");
const edge_function_provider_1 = require("./edge-function-provider");
const edge_role_1 = require("./edge-role");
const with_configuration_1 = require("./with-configuration");
class EdgeFunction extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const stack = (_b = this.stack.nestedStackParent) !== null && _b !== void 0 ? _b : this.stack;
        const { name, parameterName = `/cloudcomponents/edge-lambda/${stack.stackName}/${name}/${this.stack.node.addr}` } = props;
        this.edgeRole = (_c = props.edgeRole) !== null && _c !== void 0 ? _c : new edge_role_1.EdgeRole(this, `${name}Role`);
        this.eventType = props.eventType;
        const edgeFunction = new aws_lambda_1.Function(this.edgeStack, `${name}Function`, {
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            handler: 'index.handler',
            code: props.code,
            role: this.edgeRole.role,
        });
        const parameter = new aws_ssm_1.StringParameter(this.edgeStack, `${name}StringParameter`, {
            parameterName,
            description: 'Parameter stored for cross region Lambda@Edge',
            stringValue: edgeFunction.functionArn,
        });
        const { edgeFunction: retrievedEdgeFunction } = new edge_function_provider_1.EdgeFunctionProvider(scope, `${name}Provider`, {
            parameter,
        });
        const lambdaWithConfig = new with_configuration_1.WithConfiguration(this, 'WithConfiguration', {
            function: retrievedEdgeFunction,
            configuration: props.configuration,
        });
        this.functionVersion = lambdaWithConfig.functionVersion;
        this.lambdaFunction = this.functionVersion;
    }
}
exports.EdgeFunction = EdgeFunction;
_a = JSII_RTTI_SYMBOL_1;
EdgeFunction[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.EdgeFunction", version: "1.49.0" };
//# sourceMappingURL=data:application/json;base64,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