"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpHeaders = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
// Blacklisted headers aren't exposed and can't be added by Lambda@Edge functions:
// https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-requirements-limits.html#lambda-blacklisted-headers
const BLACKLISTED_HEADERS = [
    /^connection$/i,
    /^expect$/i,
    /^keep-alive$/i,
    /^proxy-authenticate$/i,
    /^proxy-authorization$/i,
    /^proxy-connection$/i,
    /^trailer$/i,
    /^upgrade$/i,
    /^x-accel-buffering$/i,
    /^x-accel-charset$/i,
    /^x-accel-limit-rate$/i,
    /^x-accel-redirect$/i,
    /^X-Amz-Cf-.*/i,
    /^X-Amzn-.*/i,
    /^X-Cache.*/i,
    /^X-Edge-.*/i,
    /^X-Forwarded-Proto.*/i,
    /^X-Real-IP$/i,
];
class HttpHeaders extends edge_function_1.EdgeFunction {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, {
            name: 'http-headers',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'http-headers')),
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.ORIGIN_RESPONSE,
            edgeRole: props.edgeRole,
            configuration: {
                logLevel: (_b = props.logLevel) !== null && _b !== void 0 ? _b : with_configuration_1.LogLevel.WARN,
                httpHeaders: props.httpHeaders,
            },
        });
        Object.keys(props.httpHeaders).forEach((header) => {
            if (BLACKLISTED_HEADERS.some((blheader) => blheader.test(header))) {
                throw new Error(`HttpHeader ${header} is blacklisted and can't be added by Lambda@Edge functions`);
            }
        });
    }
}
exports.HttpHeaders = HttpHeaders;
_a = JSII_RTTI_SYMBOL_1;
HttpHeaders[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.HttpHeaders", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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