"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.BaseEdgeConstruct = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class BaseEdgeConstruct extends constructs_1.Construct {
    constructor(scope, id) {
        super(scope, id);
        this.stack = aws_cdk_lib_1.Stack.of(this);
        this.edgeStack = this.stack.region !== 'us-east-1' ? this.getOrCreateCrossRegionSupportStack() : this.stack;
    }
    getOrCreateCrossRegionSupportStack() {
        var _b;
        const stack = (_b = this.stack.nestedStackParent) !== null && _b !== void 0 ? _b : this.stack;
        const { account, stackName } = stack;
        const stackId = `lambda-at-edge-support-stack`;
        const app = this.requireApp();
        let supportStack = app.node.tryFindChild(stackId);
        if (!supportStack) {
            supportStack = new aws_cdk_lib_1.Stack(app, stackId, {
                stackName: `${stackName}-support-lambda-at-edge`,
                env: {
                    account,
                    region: 'us-east-1',
                },
            });
            // the stack containing the edge lambdas must be deployed before
            this.stack.addDependency(supportStack);
        }
        return supportStack;
    }
    requireApp() {
        const app = this.node.root;
        if (!app || !aws_cdk_lib_1.App.isApp(app)) {
            throw new Error('Stacks which uses edge constructs must be part of a CDK app');
        }
        return app;
    }
}
exports.BaseEdgeConstruct = BaseEdgeConstruct;
_a = JSII_RTTI_SYMBOL_1;
BaseEdgeConstruct[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.BaseEdgeConstruct", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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