"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const base_edge_construct_1 = require("./base-edge-construct");
const edge_function_provider_1 = require("./edge-function-provider");
const edge_role_1 = require("./edge-role");
const with_configuration_1 = require("./with-configuration");
class EdgeFunction extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props) {
        var _b, _c;
        super(scope, id);
        const stack = (_b = this.stack.nestedStackParent) !== null && _b !== void 0 ? _b : this.stack;
        const { name, parameterName = `/cloudcomponents/edge-lambda/${stack.stackName}/${name}/${this.stack.node.addr}` } = props;
        this.edgeRole = (_c = props.edgeRole) !== null && _c !== void 0 ? _c : new edge_role_1.EdgeRole(this, `${name}Role`);
        this.eventType = props.eventType;
        const edgeFunction = new aws_cdk_lib_1.aws_lambda.Function(this.edgeStack, `${name}Function`, {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_14_X,
            handler: 'index.handler',
            code: props.code,
            role: this.edgeRole.role,
        });
        const parameter = new aws_cdk_lib_1.aws_ssm.StringParameter(this.edgeStack, `${name}StringParameter`, {
            parameterName,
            description: 'Parameter stored for cross region Lambda@Edge',
            stringValue: edgeFunction.functionArn,
        });
        const { edgeFunction: retrievedEdgeFunction } = new edge_function_provider_1.EdgeFunctionProvider(scope, `${name}Provider`, {
            parameter,
        });
        const lambdaWithConfig = new with_configuration_1.WithConfiguration(this, 'WithConfiguration', {
            function: retrievedEdgeFunction,
            configuration: props.configuration,
        });
        this.functionVersion = lambdaWithConfig.functionVersion;
    }
}
exports.EdgeFunction = EdgeFunction;
_a = JSII_RTTI_SYMBOL_1;
EdgeFunction[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.EdgeFunction", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWRnZS1mdW5jdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9lZGdlLWZ1bmN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQWtFO0FBR2xFLCtEQUEwRDtBQUMxRCxxRUFBZ0U7QUFFaEUsMkNBQWtEO0FBQ2xELDZEQUF3RTtBQWdCeEUsTUFBYSxZQUFhLFNBQVEsdUNBQWlCO0lBS2pELFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBd0I7O1FBQ2hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDakIsTUFBTSxLQUFLLFNBQUcsSUFBSSxDQUFDLEtBQUssQ0FBQyxpQkFBaUIsbUNBQUksSUFBSSxDQUFDLEtBQUssQ0FBQztRQUV6RCxNQUFNLEVBQUUsSUFBSSxFQUFFLGFBQWEsR0FBRyxnQ0FBZ0MsS0FBSyxDQUFDLFNBQVMsSUFBSSxJQUFJLElBQUksSUFBSSxDQUFDLEtBQUssQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLEVBQUUsR0FBRyxLQUFLLENBQUM7UUFFMUgsSUFBSSxDQUFDLFFBQVEsU0FBRyxLQUFLLENBQUMsUUFBUSxtQ0FBSSxJQUFJLG9CQUFRLENBQUMsSUFBSSxFQUFFLEdBQUcsSUFBSSxNQUFNLENBQUMsQ0FBQztRQUVwRSxJQUFJLENBQUMsU0FBUyxHQUFHLEtBQUssQ0FBQyxTQUFTLENBQUM7UUFFakMsTUFBTSxZQUFZLEdBQUcsSUFBSSx3QkFBVSxDQUFDLFFBQVEsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsSUFBSSxVQUFVLEVBQUU7WUFDOUUsT0FBTyxFQUFFLHdCQUFVLENBQUMsT0FBTyxDQUFDLFdBQVc7WUFDdkMsT0FBTyxFQUFFLGVBQWU7WUFDeEIsSUFBSSxFQUFFLEtBQUssQ0FBQyxJQUFJO1lBQ2hCLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUk7U0FDekIsQ0FBQyxDQUFDO1FBRUgsTUFBTSxTQUFTLEdBQUcsSUFBSSxxQkFBTyxDQUFDLGVBQWUsQ0FBQyxJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsSUFBSSxpQkFBaUIsRUFBRTtZQUN0RixhQUFhO1lBQ2IsV0FBVyxFQUFFLCtDQUErQztZQUM1RCxXQUFXLEVBQUUsWUFBWSxDQUFDLFdBQVc7U0FDdEMsQ0FBQyxDQUFDO1FBRUgsTUFBTSxFQUFFLFlBQVksRUFBRSxxQkFBcUIsRUFBRSxHQUFHLElBQUksNkNBQW9CLENBQUMsS0FBSyxFQUFFLEdBQUcsSUFBSSxVQUFVLEVBQUU7WUFDakcsU0FBUztTQUNWLENBQUMsQ0FBQztRQUVILE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxzQ0FBaUIsQ0FBQyxJQUFJLEVBQUUsbUJBQW1CLEVBQUU7WUFDeEUsUUFBUSxFQUFFLHFCQUFxQjtZQUMvQixhQUFhLEVBQUUsS0FBSyxDQUFDLGFBQWE7U0FDbkMsQ0FBQyxDQUFDO1FBRUgsSUFBSSxDQUFDLGVBQWUsR0FBRyxnQkFBZ0IsQ0FBQyxlQUFlLENBQUM7SUFDMUQsQ0FBQzs7QUF0Q0gsb0NBdUNDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzX2Nsb3VkZnJvbnQsIGF3c19sYW1iZGEsIGF3c19zc20gfSBmcm9tICdhd3MtY2RrLWxpYic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcblxuaW1wb3J0IHsgQmFzZUVkZ2VDb25zdHJ1Y3QgfSBmcm9tICcuL2Jhc2UtZWRnZS1jb25zdHJ1Y3QnO1xuaW1wb3J0IHsgRWRnZUZ1bmN0aW9uUHJvdmlkZXIgfSBmcm9tICcuL2VkZ2UtZnVuY3Rpb24tcHJvdmlkZXInO1xuaW1wb3J0IHsgSUVkZ2VMYW1iZGEgfSBmcm9tICcuL2VkZ2UtbGFtYmRhJztcbmltcG9ydCB7IEVkZ2VSb2xlLCBJRWRnZVJvbGUgfSBmcm9tICcuL2VkZ2Utcm9sZSc7XG5pbXBvcnQgeyBDb25maWd1cmF0aW9uLCBXaXRoQ29uZmlndXJhdGlvbiB9IGZyb20gJy4vd2l0aC1jb25maWd1cmF0aW9uJztcblxuZXhwb3J0IGludGVyZmFjZSBDb21tb25FZGdlRnVuY3Rpb25Qcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHBhcmFtZXRlck5hbWU/OiBzdHJpbmc7XG5cbiAgcmVhZG9ubHkgZWRnZVJvbGU/OiBJRWRnZVJvbGU7XG59XG5cbmV4cG9ydCBpbnRlcmZhY2UgRWRnZUZ1bmN0aW9uUHJvcHMgZXh0ZW5kcyBDb21tb25FZGdlRnVuY3Rpb25Qcm9wcyB7XG4gIHJlYWRvbmx5IGNvbmZpZ3VyYXRpb246IENvbmZpZ3VyYXRpb247XG4gIHJlYWRvbmx5IGNvZGU6IGF3c19sYW1iZGEuQ29kZTtcbiAgcmVhZG9ubHkgbmFtZTogc3RyaW5nO1xuICByZWFkb25seSBldmVudFR5cGU6IGF3c19jbG91ZGZyb250LkxhbWJkYUVkZ2VFdmVudFR5cGU7XG59XG5cbmV4cG9ydCBjbGFzcyBFZGdlRnVuY3Rpb24gZXh0ZW5kcyBCYXNlRWRnZUNvbnN0cnVjdCBpbXBsZW1lbnRzIElFZGdlTGFtYmRhIHtcbiAgcHVibGljIHJlYWRvbmx5IGVkZ2VSb2xlOiBJRWRnZVJvbGU7XG4gIHB1YmxpYyByZWFkb25seSBldmVudFR5cGU6IGF3c19jbG91ZGZyb250LkxhbWJkYUVkZ2VFdmVudFR5cGU7XG4gIHB1YmxpYyByZWFkb25seSBmdW5jdGlvblZlcnNpb246IGF3c19sYW1iZGEuSVZlcnNpb247XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVkZ2VGdW5jdGlvblByb3BzKSB7XG4gICAgc3VwZXIoc2NvcGUsIGlkKTtcbiAgICBjb25zdCBzdGFjayA9IHRoaXMuc3RhY2submVzdGVkU3RhY2tQYXJlbnQgPz8gdGhpcy5zdGFjaztcblxuICAgIGNvbnN0IHsgbmFtZSwgcGFyYW1ldGVyTmFtZSA9IGAvY2xvdWRjb21wb25lbnRzL2VkZ2UtbGFtYmRhLyR7c3RhY2suc3RhY2tOYW1lfS8ke25hbWV9LyR7dGhpcy5zdGFjay5ub2RlLmFkZHJ9YCB9ID0gcHJvcHM7XG5cbiAgICB0aGlzLmVkZ2VSb2xlID0gcHJvcHMuZWRnZVJvbGUgPz8gbmV3IEVkZ2VSb2xlKHRoaXMsIGAke25hbWV9Um9sZWApO1xuXG4gICAgdGhpcy5ldmVudFR5cGUgPSBwcm9wcy5ldmVudFR5cGU7XG5cbiAgICBjb25zdCBlZGdlRnVuY3Rpb24gPSBuZXcgYXdzX2xhbWJkYS5GdW5jdGlvbih0aGlzLmVkZ2VTdGFjaywgYCR7bmFtZX1GdW5jdGlvbmAsIHtcbiAgICAgIHJ1bnRpbWU6IGF3c19sYW1iZGEuUnVudGltZS5OT0RFSlNfMTRfWCxcbiAgICAgIGhhbmRsZXI6ICdpbmRleC5oYW5kbGVyJyxcbiAgICAgIGNvZGU6IHByb3BzLmNvZGUsXG4gICAgICByb2xlOiB0aGlzLmVkZ2VSb2xlLnJvbGUsXG4gICAgfSk7XG5cbiAgICBjb25zdCBwYXJhbWV0ZXIgPSBuZXcgYXdzX3NzbS5TdHJpbmdQYXJhbWV0ZXIodGhpcy5lZGdlU3RhY2ssIGAke25hbWV9U3RyaW5nUGFyYW1ldGVyYCwge1xuICAgICAgcGFyYW1ldGVyTmFtZSxcbiAgICAgIGRlc2NyaXB0aW9uOiAnUGFyYW1ldGVyIHN0b3JlZCBmb3IgY3Jvc3MgcmVnaW9uIExhbWJkYUBFZGdlJyxcbiAgICAgIHN0cmluZ1ZhbHVlOiBlZGdlRnVuY3Rpb24uZnVuY3Rpb25Bcm4sXG4gICAgfSk7XG5cbiAgICBjb25zdCB7IGVkZ2VGdW5jdGlvbjogcmV0cmlldmVkRWRnZUZ1bmN0aW9uIH0gPSBuZXcgRWRnZUZ1bmN0aW9uUHJvdmlkZXIoc2NvcGUsIGAke25hbWV9UHJvdmlkZXJgLCB7XG4gICAgICBwYXJhbWV0ZXIsXG4gICAgfSk7XG5cbiAgICBjb25zdCBsYW1iZGFXaXRoQ29uZmlnID0gbmV3IFdpdGhDb25maWd1cmF0aW9uKHRoaXMsICdXaXRoQ29uZmlndXJhdGlvbicsIHtcbiAgICAgIGZ1bmN0aW9uOiByZXRyaWV2ZWRFZGdlRnVuY3Rpb24sXG4gICAgICBjb25maWd1cmF0aW9uOiBwcm9wcy5jb25maWd1cmF0aW9uLFxuICAgIH0pO1xuXG4gICAgdGhpcy5mdW5jdGlvblZlcnNpb24gPSBsYW1iZGFXaXRoQ29uZmlnLmZ1bmN0aW9uVmVyc2lvbjtcbiAgfVxufVxuIl19