"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeRole = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const base_edge_construct_1 = require("./base-edge-construct");
class EdgeRole extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.role = new aws_cdk_lib_1.aws_iam.Role(this.edgeStack, id, {
            assumedBy: new aws_cdk_lib_1.aws_iam.CompositePrincipal(new aws_cdk_lib_1.aws_iam.ServicePrincipal('edgelambda.amazonaws.com'), new aws_cdk_lib_1.aws_iam.ServicePrincipal('lambda.amazonaws.com')),
            managedPolicies: [aws_cdk_lib_1.aws_iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaBasicExecutionRole')],
            ...props,
        });
    }
    addToEdgeRolePolicy(statement) {
        this.role.addToPolicy(statement);
    }
}
exports.EdgeRole = EdgeRole;
_a = JSII_RTTI_SYMBOL_1;
EdgeRole[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.EdgeRole", version: "2.1.0" };
//# sourceMappingURL=data:application/json;base64,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