import { aws_iam } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { BaseEdgeConstruct } from './base-edge-construct';
export interface IEdgeRole {
    readonly role: aws_iam.Role;
    addToEdgeRolePolicy(statement: aws_iam.PolicyStatement): void;
}
export interface EdgeRoleProps {
    readonly roleName?: string;
}
export declare class EdgeRole extends BaseEdgeConstruct implements IEdgeRole {
    readonly role: aws_iam.Role;
    constructor(scope: Construct, id: string, props?: EdgeRoleProps);
    addToEdgeRolePolicy(statement: aws_iam.PolicyStatement): void;
}
