"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunctionProvider = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
class EdgeFunctionProvider extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const cr = new aws_cdk_lib_1.custom_resources.AwsCustomResource(this, 'Resource', {
            onUpdate: {
                service: 'SSM',
                action: 'getParameter',
                parameters: {
                    Name: props.parameter.parameterName,
                },
                region: 'us-east-1',
                physicalResourceId: aws_cdk_lib_1.custom_resources.PhysicalResourceId.of(Date.now().toString()),
            },
            policy: aws_cdk_lib_1.custom_resources.AwsCustomResourcePolicy.fromSdkCalls({
                resources: [props.parameter.parameterArn],
            }),
        });
        this.edgeFunction = aws_cdk_lib_1.aws_lambda.Function.fromFunctionArn(this, 'Function', cr.getResponseField('Parameter.Value'));
    }
}
exports.EdgeFunctionProvider = EdgeFunctionProvider;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZWRnZS1mdW5jdGlvbi1wcm92aWRlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9lZGdlLWZ1bmN0aW9uLXByb3ZpZGVyLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7OztBQUFBLDZDQUFvRTtBQUNwRSwyQ0FBdUM7QUFNdkMsTUFBYSxvQkFBcUIsU0FBUSxzQkFBUztJQUdqRCxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWdDO1FBQ3hFLEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFFakIsTUFBTSxFQUFFLEdBQUcsSUFBSSw4QkFBZ0IsQ0FBQyxpQkFBaUIsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFO1lBQ2xFLFFBQVEsRUFBRTtnQkFDUixPQUFPLEVBQUUsS0FBSztnQkFDZCxNQUFNLEVBQUUsY0FBYztnQkFDdEIsVUFBVSxFQUFFO29CQUNWLElBQUksRUFBRSxLQUFLLENBQUMsU0FBUyxDQUFDLGFBQWE7aUJBQ3BDO2dCQUNELE1BQU0sRUFBRSxXQUFXO2dCQUNuQixrQkFBa0IsRUFBRSw4QkFBZ0IsQ0FBQyxrQkFBa0IsQ0FBQyxFQUFFLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxDQUFDLFFBQVEsRUFBRSxDQUFDO2FBQ2xGO1lBQ0QsTUFBTSxFQUFFLDhCQUFnQixDQUFDLHVCQUF1QixDQUFDLFlBQVksQ0FBQztnQkFDNUQsU0FBUyxFQUFFLENBQUMsS0FBSyxDQUFDLFNBQVMsQ0FBQyxZQUFZLENBQUM7YUFDMUMsQ0FBQztTQUNILENBQUMsQ0FBQztRQUVILElBQUksQ0FBQyxZQUFZLEdBQUcsd0JBQVUsQ0FBQyxRQUFRLENBQUMsZUFBZSxDQUFDLElBQUksRUFBRSxVQUFVLEVBQUUsRUFBRSxDQUFDLGdCQUFnQixDQUFDLGlCQUFpQixDQUFDLENBQUMsQ0FBQztJQUNwSCxDQUFDO0NBQ0Y7QUF2QkQsb0RBdUJDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgYXdzX2xhbWJkYSwgYXdzX3NzbSwgY3VzdG9tX3Jlc291cmNlcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gJ2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgaW50ZXJmYWNlIEVkZ2VGdW5jdGlvblByb3ZpZGVyUHJvcHMge1xuICByZWFkb25seSBwYXJhbWV0ZXI6IGF3c19zc20uSVN0cmluZ1BhcmFtZXRlcjtcbn1cblxuZXhwb3J0IGNsYXNzIEVkZ2VGdW5jdGlvblByb3ZpZGVyIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcHVibGljIHJlYWRvbmx5IGVkZ2VGdW5jdGlvbjogYXdzX2xhbWJkYS5JRnVuY3Rpb247XG5cbiAgY29uc3RydWN0b3Ioc2NvcGU6IENvbnN0cnVjdCwgaWQ6IHN0cmluZywgcHJvcHM6IEVkZ2VGdW5jdGlvblByb3ZpZGVyUHJvcHMpIHtcbiAgICBzdXBlcihzY29wZSwgaWQpO1xuXG4gICAgY29uc3QgY3IgPSBuZXcgY3VzdG9tX3Jlc291cmNlcy5Bd3NDdXN0b21SZXNvdXJjZSh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICBvblVwZGF0ZToge1xuICAgICAgICBzZXJ2aWNlOiAnU1NNJyxcbiAgICAgICAgYWN0aW9uOiAnZ2V0UGFyYW1ldGVyJyxcbiAgICAgICAgcGFyYW1ldGVyczoge1xuICAgICAgICAgIE5hbWU6IHByb3BzLnBhcmFtZXRlci5wYXJhbWV0ZXJOYW1lLFxuICAgICAgICB9LFxuICAgICAgICByZWdpb246ICd1cy1lYXN0LTEnLFxuICAgICAgICBwaHlzaWNhbFJlc291cmNlSWQ6IGN1c3RvbV9yZXNvdXJjZXMuUGh5c2ljYWxSZXNvdXJjZUlkLm9mKERhdGUubm93KCkudG9TdHJpbmcoKSksIC8vIFVwZGF0ZSBwaHlzaWNhbCBpZCB0byBhbHdheXMgZmV0Y2ggdGhlIGxhdGVzdCB2ZXJzaW9uXG4gICAgICB9LFxuICAgICAgcG9saWN5OiBjdXN0b21fcmVzb3VyY2VzLkF3c0N1c3RvbVJlc291cmNlUG9saWN5LmZyb21TZGtDYWxscyh7XG4gICAgICAgIHJlc291cmNlczogW3Byb3BzLnBhcmFtZXRlci5wYXJhbWV0ZXJBcm5dLFxuICAgICAgfSksXG4gICAgfSk7XG5cbiAgICB0aGlzLmVkZ2VGdW5jdGlvbiA9IGF3c19sYW1iZGEuRnVuY3Rpb24uZnJvbUZ1bmN0aW9uQXJuKHRoaXMsICdGdW5jdGlvbicsIGNyLmdldFJlc3BvbnNlRmllbGQoJ1BhcmFtZXRlci5WYWx1ZScpKTtcbiAgfVxufVxuIl19