"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EdgeFunction = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const base_edge_construct_1 = require("./base-edge-construct");
const edge_function_provider_1 = require("./edge-function-provider");
const edge_role_1 = require("./edge-role");
const with_configuration_1 = require("./with-configuration");
class EdgeFunction extends base_edge_construct_1.BaseEdgeConstruct {
    constructor(scope, id, props) {
        super(scope, id);
        const stack = this.stack.nestedStackParent ?? this.stack;
        const { name, parameterName = `/cloudcomponents/edge-lambda/${stack.stackName}/${name}/${this.stack.node.addr}` } = props;
        this.edgeRole = props.edgeRole ?? new edge_role_1.EdgeRole(this, `${name}Role`);
        this.eventType = props.eventType;
        const edgeFunction = new aws_cdk_lib_1.aws_lambda.Function(this.edgeStack, `${name}Function`, {
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            handler: 'index.handler',
            code: props.code,
            role: this.edgeRole.role,
        });
        const parameter = new aws_cdk_lib_1.aws_ssm.StringParameter(this.edgeStack, `${name}StringParameter`, {
            parameterName,
            description: 'Parameter stored for cross region Lambda@Edge',
            stringValue: edgeFunction.functionArn,
        });
        const { edgeFunction: retrievedEdgeFunction } = new edge_function_provider_1.EdgeFunctionProvider(scope, `${name}Provider`, {
            parameter,
        });
        const lambdaWithConfig = new with_configuration_1.WithConfiguration(this, 'WithConfiguration', {
            function: retrievedEdgeFunction,
            configuration: props.configuration,
        });
        this.functionVersion = lambdaWithConfig.functionVersion;
    }
}
exports.EdgeFunction = EdgeFunction;
_a = JSII_RTTI_SYMBOL_1;
EdgeFunction[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.EdgeFunction", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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