"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpHeaders = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const edge_function_1 = require("./edge-function");
const with_configuration_1 = require("./with-configuration");
// Blacklisted headers aren't exposed and can't be added by Lambda@Edge functions:
// https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/lambda-requirements-limits.html#lambda-blacklisted-headers
const BLACKLISTED_HEADERS = [
    /^connection$/i,
    /^expect$/i,
    /^keep-alive$/i,
    /^proxy-authenticate$/i,
    /^proxy-authorization$/i,
    /^proxy-connection$/i,
    /^trailer$/i,
    /^upgrade$/i,
    /^x-accel-buffering$/i,
    /^x-accel-charset$/i,
    /^x-accel-limit-rate$/i,
    /^x-accel-redirect$/i,
    /^X-Amz-Cf-.*/i,
    /^X-Amzn-.*/i,
    /^X-Cache.*/i,
    /^X-Edge-.*/i,
    /^X-Forwarded-Proto.*/i,
    /^X-Real-IP$/i,
];
class HttpHeaders extends edge_function_1.EdgeFunction {
    constructor(scope, id, props) {
        super(scope, id, {
            name: 'http-headers',
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'http-headers')),
            eventType: aws_cdk_lib_1.aws_cloudfront.LambdaEdgeEventType.ORIGIN_RESPONSE,
            edgeRole: props.edgeRole,
            configuration: {
                logLevel: props.logLevel ?? with_configuration_1.LogLevel.WARN,
                httpHeaders: props.httpHeaders,
            },
        });
        Object.keys(props.httpHeaders).forEach((header) => {
            if (BLACKLISTED_HEADERS.some((blheader) => blheader.test(header))) {
                throw new Error(`HttpHeader ${header} is blacklisted and can't be added by Lambda@Edge functions`);
            }
        });
    }
}
exports.HttpHeaders = HttpHeaders;
_a = JSII_RTTI_SYMBOL_1;
HttpHeaders[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.HttpHeaders", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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