"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.WithConfiguration = exports.LogLevel = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const constructs_1 = require("constructs");
var LogLevel;
(function (LogLevel) {
    LogLevel["NONE"] = "none";
    LogLevel["INFO"] = "info";
    LogLevel["WARN"] = "warn";
    LogLevel["ERROR"] = "error";
    LogLevel["DEBUG"] = "debug";
})(LogLevel = exports.LogLevel || (exports.LogLevel = {}));
class WithConfiguration extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const resourceType = 'Custom::WithConfiguration';
        const handler = new aws_cdk_lib_1.aws_lambda.SingletonFunction(this, 'Handler', {
            uuid: 'cloudcomponents-cdk-lambda-at-edge-pattern-with-configuration',
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.NODEJS_18_X,
            code: aws_cdk_lib_1.aws_lambda.Code.fromAsset(path.join(__dirname, 'lambdas', 'with-configuration')),
            handler: 'index.handler',
            lambdaPurpose: resourceType,
            timeout: aws_cdk_lib_1.Duration.minutes(5),
        });
        handler.addToRolePolicy(new aws_cdk_lib_1.aws_iam.PolicyStatement({
            effect: aws_cdk_lib_1.aws_iam.Effect.ALLOW,
            actions: ['lambda:GetFunction', 'lambda:UpdateFunctionCode'],
            resources: [props.function.functionArn],
        }));
        const cr = new aws_cdk_lib_1.CustomResource(this, 'WithConfiguration', {
            serviceToken: handler.functionArn,
            resourceType,
            properties: {
                Region: 'us-east-1',
                FunctionName: props.function.functionName,
                Configuration: JSON.stringify(props.configuration, null, 2),
            },
        });
        this.functionVersion = aws_cdk_lib_1.aws_lambda.Version.fromVersionArn(this, 'Version', cr.getAttString('FunctionArn'));
    }
}
exports.WithConfiguration = WithConfiguration;
_a = JSII_RTTI_SYMBOL_1;
WithConfiguration[_a] = { fqn: "@cloudcomponents/cdk-lambda-at-edge-pattern.WithConfiguration", version: "2.3.0" };
//# sourceMappingURL=data:application/json;base64,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